
nacelle_offset=10;
engine_length=50;
nacelle_diameter=5;
nacelle_radius=nacelle_diameter/2;
body_diameter=1.25*nacelle_diameter;

//============================================ engines
translate(v=[0,0,8])
union() {

// right engine
color("red") {
    translate(v=[0,nacelle_offset,0]) 
        sphere(r=nacelle_diameter);     // engine front
    translate(v=[0,nacelle_offset,0]) 
        cylinder(h=engine_length, r1=nacelle_diameter, r2=5);  // engine main
    translate(v=[0,nacelle_offset,engine_length]) 
        cylinder(h=nacelle_diameter, r1=nacelle_diameter, r2=nacelle_radius);  // exhaust
} // red engine

// left engine
color("blue") {
    translate(v=[0,-nacelle_offset,0]) 
        sphere(r=nacelle_diameter);     // engine front
    translate(v=[0,-nacelle_offset,0]) 
        cylinder(h=engine_length, r1=nacelle_diameter, r2=5);  // engine main
    translate(v=[0,-nacelle_offset,engine_length]) 
        cylinder(h=nacelle_diameter, r1=nacelle_diameter, r2=nacelle_radius);  // exhaust
} // green engine

// left engine support
color("blue") 
    rotate(a=[0,0,30]) 
    translate(v=[-5,-nacelle_offset,5])
    cube(size=[12,nacelle_radius,0.75*engine_length]);

// right engine support
color("red")  
    rotate(a=[0,0,-30])
    translate(v=[-5,nacelle_offset-nacelle_radius,5])
    cube(size=[12,nacelle_radius,0.75*engine_length]);

} //============================================ engines

color("brown")
union() { //======================================== body
translate(v=[10,0,-20])     
    cylinder(h=engine_length*1.5, r1=1.25*nacelle_diameter, r2=1.25*nacelle_diameter);

translate(v=[10,0,-20])
    sphere(r=body_diameter);

translate(v=[10,0,55])
    cylinder(h=body_diameter/2, r1=body_diameter, r2=body_diameter/2);

} //============================================= body

color("purple")
    translate(v=[5,-2.5,0])
    rotate(a=[-90,90,0])
    linear_extrude(height=5)
    polygon(points=[ [0,0], [20,0], [25,15], [5,15] ]);

//================================== saucer section
// color("grey")
translate(v=[-10,0,-20])
union() {
    color("green")
    rotate(a=[0,90,0]) 
        cylinder(h=5,r1=35,r2=15);  // lower half of saucer
    rotate(a=[0,270,0]) {       
        cylinder(h=5,r1=35,r2=15);  // upper half of saucer

} 
}




