/*
  main.cpp - Main loop for Arduino sketches
  Copyright (c) 2005-2013 Arduino Team.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "main.h"
////Declared weak in Arduino.h to allow user redefinitions.
// int atexit(void (* /*func*/ )()) { return 0; }

////Weak empty variant initialization function.
////May be redefined by variant files.
// void initVariant() __attribute__((weak));
// void initVariant() { }
// void setupUSB() __attribute__((weak));
// void setupUSB() { }

//void backToMenu ();
volatile bool _flag_evive_menu;

void backToMenu (void)
{
	_flag_evive_menu = 1;
}

int main(void)
{
	init();

	initVariant();

#if defined(USBCON)
	USBDevice.attach();
#endif
	
	setup();
	attachInterrupt(digitalPinToInterrupt(19), backToMenu, RISING);
	for (;;) {
		//unsigned long _ti = pulseInLong(19,HIGH);
		if (_flag_evive_menu)
		{ 
	        menuPress = 1;
			eviveFirmware();
			setup();
		}
		_flag_evive_menu =0;
		
		loop();
		
		if (serialEventRun) serialEventRun();

	}
        
	return 0;
}