//internet.h#include <SoftwareSerial.h>
#include "arduino.h"
// <a href="https://nurdspace.nl/ESP8266" rel="nofollow"> https://nurdspace.nl/ESP8266</a>
//http://www.instructables.com/id/Using-the-ESP8266-module/
//https://www.zybuluo.com/kfihihc/note/31135
//http://tminusarduino.blogspot.nl/2014/09/experimenting-with-esp8266-5-wifi-module.html
//http://www.cse.dmu.ac.uk/~sexton/ESP8266/
//https://github.com/aabella/ESP8266-Arduino-library/blob/master/ESP8266abella/ESP8266aabella.h
//http://contractorwolf.com/esp8266-wifi-arduino-micro/
//**********************************************************

#define DEBUG FALSE //comment out to remove debug msgs

//*-- Software Serial this is a virtual serial port to connect to the ESP8266
#define _rxpin      11
#define _txpin      10
SoftwareSerial module( _rxpin, _txpin ); // RX, TX

//*-- IoT Information enter wifi password and name
#define SSID "YourWifiNameHere"
#define PASS "YourWifiPassHere"

#define IP "184.106.153.149" // ThingSpeak IP Address: 184.106.153.149


String GET = "GET /update?api_key=your_key_here";//your api key here

void sendDebug(String cmd)
{
  //Serial.print("SEND: ");
  //Serial.println(cmd);
  module.println(cmd);
}

//----- update the  Thingspeak string with 3 values
void updateTS( String T, String L , String H)
{
  // ESP8266 Client
  String cmd = "AT+CIPSTART=\"TCP\",\"";// Setup TCP connection
  cmd += IP;
  cmd += "\",80";
  sendDebug(cmd);
  delay(2000);
  if ( module.find( "Error" ) )
  {
    //Serial.print( "RECEIVED: Error\nExit1" );
    return;
  }

  // cmd = GET + "&field1=5"  +"\r\n";
  cmd = GET + "&field1=" + T + "&field2=" + L + "&field3=" + H + "\r\n";

  module.print( "AT+CIPSEND=" );
  module.println( cmd.length() );
  if (module.find( ">" ) )
  {
    //Serial.print(">");
    //Serial.print(cmd);
    module.print(cmd);
  }
  else
  {
    sendDebug( "AT+CIPCLOSE" );//close TCP connection
  }
  if ( module.find("OK") )
  {
    //Serial.println( "RECEIVED: OK" );
  }
  else
  {
    //Serial.println( "RECEIVED: Error\nExit2" );
  }
}

boolean connectWiFi()
{
  module.println("AT+CWMODE=1");//WiFi STA mode - if '3' it is both client and AP
  delay(2000);
  //Connect to Router with AT+CWJAP="SSID","Password";
  // Check if connected with AT+CWJAP?
  String cmd = "AT+CWJAP=\""; // Join accespoint
  cmd += SSID;
  cmd += "\",\"";
  cmd += PASS;
  cmd += "\"";
  sendDebug(cmd);
  delay(5000);
  if (module.find("OK"))
  {
    //Serial.println("RECEIVED: OK");
    return true;
  }
  else
  {
    //Serial.println("RECEIVED: Error");
    return false;
  }

  cmd = "AT+CIPMUX=0";// Set Single connection
  sendDebug( cmd );
  if ( module.find( "Error") )
  {
    //Serial.print( "RECEIVED: Error" );
    return false;
  }
}
