/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;

public class PImage
implements PConstants,
Cloneable {
    public int format;
    public int[] pixels;
    public int pixelDensity = 1;
    public int pixelWidth;
    public int pixelHeight;
    public int width;
    public int height;
    public PApplet parent;
    protected boolean modified;
    protected int mx1;
    protected int my1;
    protected int mx2;
    protected int my2;
    public boolean loaded = false;
    private int fracU;
    private int ifU;
    private int fracV;
    private int ifV;
    private int u1;
    private int u2;
    private int v1;
    private int v2;
    private int sX;
    private int sY;
    private int iw;
    private int iw1;
    private int ih1;
    private int ul;
    private int ll;
    private int ur;
    private int lr;
    private int cUL;
    private int cLL;
    private int cUR;
    private int cLR;
    private int srcXOffset;
    private int srcYOffset;
    private int r;
    private int g;
    private int b;
    private int a;
    private int[] srcBuffer;
    static final int PRECISIONB = 15;
    static final int PRECISIONF = 32768;
    static final int PREC_MAXVAL = Short.MAX_VALUE;
    static final int PREC_ALPHA_SHIFT = 9;
    static final int PREC_RED_SHIFT = 1;
    private int blurRadius;
    private int blurKernelSize;
    private int[] blurKernel;
    private int[][] blurMult;
    public static final int ALPHA_MASK = -16777216;
    public static final int RED_MASK = 0xFF0000;
    public static final int GREEN_MASK = 65280;
    public static final int BLUE_MASK = 255;
    private static final int RB_MASK = 0xFF00FF;
    private static final int GN_MASK = 65280;
    static byte[] TIFF_HEADER;
    static final String TIFF_ERROR = "Error: Processing can only read its own TIFF files.";
    protected String[] saveImageFormats;

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 77;
        byArray[1] = 77;
        byArray[3] = 42;
        byArray[7] = 8;
        byArray[9] = 9;
        byArray[11] = -2;
        byArray[13] = 4;
        byArray[17] = 1;
        byArray[22] = 1;
        byArray[25] = 3;
        byArray[29] = 1;
        byArray[34] = 1;
        byArray[35] = 1;
        byArray[37] = 3;
        byArray[41] = 1;
        byArray[46] = 1;
        byArray[47] = 2;
        byArray[49] = 3;
        byArray[53] = 3;
        byArray[57] = 122;
        byArray[58] = 1;
        byArray[59] = 6;
        byArray[61] = 3;
        byArray[65] = 1;
        byArray[67] = 2;
        byArray[70] = 1;
        byArray[71] = 17;
        byArray[73] = 4;
        byArray[77] = 1;
        byArray[80] = 3;
        byArray[82] = 1;
        byArray[83] = 21;
        byArray[85] = 3;
        byArray[89] = 1;
        byArray[91] = 3;
        byArray[94] = 1;
        byArray[95] = 22;
        byArray[97] = 3;
        byArray[101] = 1;
        byArray[106] = 1;
        byArray[107] = 23;
        byArray[109] = 4;
        byArray[113] = 1;
        byArray[123] = 8;
        byArray[125] = 8;
        byArray[127] = 8;
        TIFF_HEADER = byArray;
    }

    public PImage() {
        this.format = 2;
        this.pixelDensity = 1;
    }

    public PImage(int width, int height) {
        this.init(width, height, 1, 1);
    }

    public PImage(int width, int height, int format) {
        this.init(width, height, format, 1);
    }

    public PImage(int width, int height, int format, int factor) {
        this.init(width, height, format, factor);
    }

    public void init(int width, int height, int format) {
        this.init(width, height, format, 1);
    }

    public void init(int width, int height, int format, int factor) {
        this.width = width;
        this.height = height;
        this.format = format;
        this.pixelDensity = factor;
        this.pixelWidth = width * this.pixelDensity;
        this.pixelHeight = height * this.pixelDensity;
        this.pixels = new int[this.pixelWidth * this.pixelHeight];
    }

    protected void checkAlpha() {
        if (this.pixels == null) {
            return;
        }
        int i = 0;
        while (i < this.pixels.length) {
            if ((this.pixels[i] & 0xFF000000) != -16777216) {
                this.format = 2;
                break;
            }
            ++i;
        }
    }

    public PImage(Image img) {
        this.format = 1;
        if (img instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)img;
            this.width = bi.getWidth();
            this.height = bi.getHeight();
            int type = bi.getType();
            if (type == 5 || type == 6) {
                this.pixels = new int[this.width * this.height];
                bi.getRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
                if (type == 6) {
                    this.format = 2;
                } else {
                    this.opaque();
                }
            } else {
                DataBuffer db = bi.getRaster().getDataBuffer();
                if (db instanceof DataBufferInt) {
                    this.pixels = ((DataBufferInt)db).getData();
                    if (type == 2) {
                        this.format = 2;
                    } else if (type == 1) {
                        this.opaque();
                    }
                }
            }
        }
        if (this.pixels == null) {
            this.width = img.getWidth(null);
            this.height = img.getHeight(null);
            this.pixels = new int[this.width * this.height];
            PixelGrabber pg = new PixelGrabber(img, 0, 0, this.width, this.height, this.pixels, 0, this.width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.pixelDensity = 1;
        this.pixelWidth = this.width;
        this.pixelHeight = this.height;
    }

    @Deprecated
    public Image getImage() {
        return (Image)this.getNative();
    }

    public Object getNative() {
        this.loadPixels();
        int type = this.format == 1 ? 1 : 2;
        BufferedImage image = new BufferedImage(this.pixelWidth, this.pixelHeight, type);
        WritableRaster wr = image.getRaster();
        wr.setDataElements(0, 0, this.pixelWidth, this.pixelHeight, this.pixels);
        return image;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
        this.mx1 = 0;
        this.my1 = 0;
        this.mx2 = this.pixelWidth;
        this.my2 = this.pixelHeight;
    }

    public void setModified(boolean m) {
        this.modified = m;
    }

    public int getModifiedX1() {
        return this.mx1;
    }

    public int getModifiedX2() {
        return this.mx2;
    }

    public int getModifiedY1() {
        return this.my1;
    }

    public int getModifiedY2() {
        return this.my2;
    }

    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.pixelWidth * this.pixelHeight) {
            this.pixels = new int[this.pixelWidth * this.pixelHeight];
        }
        this.setLoaded();
    }

    public void updatePixels() {
        this.updatePixels(0, 0, this.pixelWidth, this.pixelHeight);
    }

    public void updatePixels(int x, int y, int w, int h) {
        int x2 = x + w;
        int y2 = y + h;
        if (!this.modified) {
            this.mx1 = PApplet.max(0, x);
            this.mx2 = PApplet.min(this.pixelWidth, x2);
            this.my1 = PApplet.max(0, y);
            this.my2 = PApplet.min(this.pixelHeight, y2);
            this.modified = true;
        } else {
            if (x < this.mx1) {
                this.mx1 = PApplet.max(0, x);
            }
            if (x > this.mx2) {
                this.mx2 = PApplet.min(this.pixelWidth, x);
            }
            if (y < this.my1) {
                this.my1 = PApplet.max(0, y);
            }
            if (y > this.my2) {
                this.my2 = PApplet.min(this.pixelHeight, y);
            }
            if (x2 < this.mx1) {
                this.mx1 = PApplet.max(0, x2);
            }
            if (x2 > this.mx2) {
                this.mx2 = PApplet.min(this.pixelWidth, x2);
            }
            if (y2 < this.my1) {
                this.my1 = PApplet.max(0, y2);
            }
            if (y2 > this.my2) {
                this.my2 = PApplet.min(this.pixelHeight, y2);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return this.get();
    }

    public void resize(int w, int h) {
        float diff;
        if (w <= 0 && h <= 0) {
            throw new IllegalArgumentException("width or height must be > 0 for resize");
        }
        if (w == 0) {
            diff = (float)h / (float)this.height;
            w = (int)((float)this.width * diff);
        } else if (h == 0) {
            diff = (float)w / (float)this.width;
            h = (int)((float)this.height * diff);
        }
        BufferedImage img = PImage.shrinkImage((BufferedImage)this.getNative(), w * this.pixelDensity, h * this.pixelDensity);
        PImage temp = new PImage(img);
        this.pixelWidth = temp.width;
        this.pixelHeight = temp.height;
        this.pixels = temp.pixels;
        this.width = this.pixelWidth / this.pixelDensity;
        this.height = this.pixelHeight / this.pixelDensity;
        this.updatePixels();
    }

    private static BufferedImage shrinkImage(BufferedImage img, int targetWidth, int targetHeight) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage outgoing = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = outgoing.getWidth();
        int prevH = outgoing.getHeight();
        boolean isTranslucent = img.getTransparency() != 1;
        int w = img.getWidth();
        int h = img.getHeight();
        do {
            if (w > targetWidth) {
                if ((w /= 2) < targetWidth) {
                    w = targetWidth;
                }
            } else if (targetWidth >= w) {
                w = targetWidth;
            }
            if (h > targetHeight) {
                if ((h /= 2) < targetHeight) {
                    h = targetHeight;
                }
            } else if (targetHeight >= h) {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(outgoing, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            outgoing = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != outgoing.getWidth() || targetHeight != outgoing.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)outgoing, 0, 0, null);
            g2.dispose();
            outgoing = scratchImage;
        }
        return outgoing;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded() {
        this.loaded = true;
    }

    public void setLoaded(boolean l) {
        this.loaded = l;
    }

    public int get(int x, int y) {
        if (x < 0 || y < 0 || x >= this.pixelWidth || y >= this.pixelHeight) {
            return 0;
        }
        switch (this.format) {
            case 1: {
                return this.pixels[y * this.pixelWidth + x] | 0xFF000000;
            }
            case 2: {
                return this.pixels[y * this.pixelWidth + x];
            }
            case 4: {
                return this.pixels[y * this.pixelWidth + x] << 24 | 0xFFFFFF;
            }
        }
        return 0;
    }

    public PImage get(int x, int y, int w, int h) {
        int targetX = 0;
        int targetY = 0;
        int targetWidth = w;
        int targetHeight = h;
        boolean cropped = false;
        if (x < 0) {
            w += x;
            targetX = -x;
            cropped = true;
            x = 0;
        }
        if (y < 0) {
            h += y;
            targetY = -y;
            cropped = true;
            y = 0;
        }
        if (x + w > this.pixelWidth) {
            w = this.pixelWidth - x;
            cropped = true;
        }
        if (y + h > this.pixelHeight) {
            h = this.pixelHeight - y;
            cropped = true;
        }
        if (w < 0) {
            w = 0;
        }
        if (h < 0) {
            h = 0;
        }
        int targetFormat = this.format;
        if (cropped && this.format == 1) {
            targetFormat = 2;
        }
        PImage target = new PImage(targetWidth / this.pixelDensity, targetHeight / this.pixelDensity, targetFormat, this.pixelDensity);
        target.parent = this.parent;
        if (w > 0 && h > 0) {
            this.getImpl(x, y, w, h, target, targetX, targetY);
        }
        return target;
    }

    public PImage get() {
        return this.get(0, 0, this.pixelWidth, this.pixelHeight);
    }

    public PImage copy() {
        return this.get(0, 0, this.pixelWidth, this.pixelHeight);
    }

    protected void getImpl(int sourceX, int sourceY, int sourceWidth, int sourceHeight, PImage target, int targetX, int targetY) {
        int sourceIndex = sourceY * this.pixelWidth + sourceX;
        int targetIndex = targetY * target.pixelWidth + targetX;
        int row = 0;
        while (row < sourceHeight) {
            System.arraycopy(this.pixels, sourceIndex, target.pixels, targetIndex, sourceWidth);
            sourceIndex += this.pixelWidth;
            targetIndex += target.pixelWidth;
            ++row;
        }
    }

    public void set(int x, int y, int c) {
        if (x < 0 || y < 0 || x >= this.pixelWidth || y >= this.pixelHeight) {
            return;
        }
        this.pixels[y * this.pixelWidth + x] = c;
        this.updatePixels(x, y, 1, 1);
    }

    public void set(int x, int y, PImage img) {
        int sx = 0;
        int sy = 0;
        int sw = img.pixelWidth;
        int sh = img.pixelHeight;
        if (x < 0) {
            sx -= x;
            sw += x;
            x = 0;
        }
        if (y < 0) {
            sy -= y;
            sh += y;
            y = 0;
        }
        if (x + sw > this.pixelWidth) {
            sw = this.pixelWidth - x;
        }
        if (y + sh > this.pixelHeight) {
            sh = this.pixelHeight - y;
        }
        if (sw <= 0 || sh <= 0) {
            return;
        }
        this.setImpl(img, sx, sy, sw, sh, x, y);
    }

    protected void setImpl(PImage sourceImage, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int targetX, int targetY) {
        int sourceOffset = sourceY * sourceImage.pixelWidth + sourceX;
        int targetOffset = targetY * this.pixelWidth + targetX;
        int y = sourceY;
        while (y < sourceY + sourceHeight) {
            System.arraycopy(sourceImage.pixels, sourceOffset, this.pixels, targetOffset, sourceWidth);
            sourceOffset += sourceImage.pixelWidth;
            targetOffset += this.pixelWidth;
            ++y;
        }
        this.updatePixels(targetX, targetY, sourceWidth, sourceHeight);
    }

    @Deprecated
    public void mask(int[] maskArray) {
        this.loadPixels();
        if (maskArray.length != this.pixels.length) {
            throw new IllegalArgumentException("mask() can only be used with an image that's the same size.");
        }
        int i = 0;
        while (i < this.pixels.length) {
            this.pixels[i] = (maskArray[i] & 0xFF) << 24 | this.pixels[i] & 0xFFFFFF;
            ++i;
        }
        this.format = 2;
        this.updatePixels();
    }

    public void mask(PImage img) {
        img.loadPixels();
        this.mask(img.pixels);
    }

    public void filter(int kind) {
        this.loadPixels();
        switch (kind) {
            case 11: {
                this.filter(11, 1.0f);
                break;
            }
            case 12: {
                if (this.format == 4) {
                    int i = 0;
                    while (i < this.pixels.length) {
                        int col = 255 - this.pixels[i];
                        this.pixels[i] = 0xFF000000 | col << 16 | col << 8 | col;
                        ++i;
                    }
                    this.format = 1;
                    break;
                }
                int i = 0;
                while (i < this.pixels.length) {
                    int col = this.pixels[i];
                    int lum = 77 * (col >> 16 & 0xFF) + 151 * (col >> 8 & 0xFF) + 28 * (col & 0xFF) >> 8;
                    this.pixels[i] = col & 0xFF000000 | lum << 16 | lum << 8 | lum;
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.pixels.length) {
                    int n = i++;
                    this.pixels[n] = this.pixels[n] ^ 0xFFFFFF;
                }
                break;
            }
            case 15: {
                throw new RuntimeException("Use filter(POSTERIZE, int levels) instead of filter(POSTERIZE)");
            }
            case 14: {
                int i = 0;
                while (i < this.pixels.length) {
                    int n = i++;
                    this.pixels[n] = this.pixels[n] | 0xFF000000;
                }
                this.format = 1;
                break;
            }
            case 16: {
                this.filter(16, 0.5f);
                break;
            }
            case 17: {
                this.erode();
                break;
            }
            case 18: {
                this.dilate();
            }
        }
        this.updatePixels();
    }

    public void filter(int kind, float param) {
        this.loadPixels();
        switch (kind) {
            case 11: {
                if (this.format == 4) {
                    this.blurAlpha(param);
                    break;
                }
                if (this.format == 2) {
                    this.blurARGB(param);
                    break;
                }
                this.blurRGB(param);
                break;
            }
            case 12: {
                throw new RuntimeException("Use filter(GRAY) instead of filter(GRAY, param)");
            }
            case 13: {
                throw new RuntimeException("Use filter(INVERT) instead of filter(INVERT, param)");
            }
            case 14: {
                throw new RuntimeException("Use filter(OPAQUE) instead of filter(OPAQUE, param)");
            }
            case 15: {
                int levels = (int)param;
                if (levels < 2 || levels > 255) {
                    throw new RuntimeException("Levels must be between 2 and 255 for filter(POSTERIZE, levels)");
                }
                int levels1 = levels - 1;
                int i = 0;
                while (i < this.pixels.length) {
                    int rlevel = this.pixels[i] >> 16 & 0xFF;
                    int glevel = this.pixels[i] >> 8 & 0xFF;
                    int blevel = this.pixels[i] & 0xFF;
                    rlevel = (rlevel * levels >> 8) * 255 / levels1;
                    glevel = (glevel * levels >> 8) * 255 / levels1;
                    blevel = (blevel * levels >> 8) * 255 / levels1;
                    this.pixels[i] = 0xFF000000 & this.pixels[i] | rlevel << 16 | glevel << 8 | blevel;
                    ++i;
                }
                break;
            }
            case 16: {
                int thresh = (int)(param * 255.0f);
                int i = 0;
                while (i < this.pixels.length) {
                    int max = Math.max((this.pixels[i] & 0xFF0000) >> 16, Math.max((this.pixels[i] & 0xFF00) >> 8, this.pixels[i] & 0xFF));
                    this.pixels[i] = this.pixels[i] & 0xFF000000 | (max < thresh ? 0 : 0xFFFFFF);
                    ++i;
                }
                break;
            }
            case 17: {
                throw new RuntimeException("Use filter(ERODE) instead of filter(ERODE, param)");
            }
            case 18: {
                throw new RuntimeException("Use filter(DILATE) instead of filter(DILATE, param)");
            }
        }
        this.updatePixels();
    }

    protected void opaque() {
        int i = 0;
        while (i < this.pixels.length) {
            this.pixels[i] = 0xFF000000 | this.pixels[i];
            ++i;
        }
    }

    protected void buildBlurKernel(float r) {
        int radius = (int)(r * 3.5f);
        int n = radius < 1 ? 1 : (radius = radius < 248 ? radius : 248);
        if (this.blurRadius != radius) {
            int[] bm;
            this.blurRadius = radius;
            this.blurKernelSize = 1 + this.blurRadius << 1;
            this.blurKernel = new int[this.blurKernelSize];
            this.blurMult = new int[this.blurKernelSize][256];
            int i = 1;
            int radiusi = radius - 1;
            while (i < radius) {
                int bki;
                this.blurKernel[radiusi] = bki = radiusi * radiusi;
                this.blurKernel[radius + i] = bki;
                bm = this.blurMult[radius + i];
                int[] bmi = this.blurMult[radiusi--];
                int j = 0;
                while (j < 256) {
                    bm[j] = bmi[j] = bki * j;
                    ++j;
                }
                ++i;
            }
            int bk = this.blurKernel[radius] = radius * radius;
            bm = this.blurMult[radius];
            int j = 0;
            while (j < 256) {
                bm[j] = bk * j;
                ++j;
            }
        }
    }

    protected void blurAlpha(float r) {
        int ri;
        int i;
        int bk0;
        int read;
        int cb;
        int sum;
        int x;
        int[] b2 = new int[this.pixels.length];
        int yi = 0;
        this.buildBlurKernel(r);
        int y = 0;
        while (y < this.pixelHeight) {
            x = 0;
            while (x < this.pixelWidth) {
                sum = 0;
                cb = 0;
                read = x - this.blurRadius;
                if (read < 0) {
                    bk0 = -read;
                    read = 0;
                } else {
                    if (read >= this.pixelWidth) break;
                    bk0 = 0;
                }
                i = bk0;
                while (i < this.blurKernelSize) {
                    if (read >= this.pixelWidth) break;
                    int c = this.pixels[read + yi];
                    int[] bm = this.blurMult[i];
                    cb += bm[c & 0xFF];
                    sum += this.blurKernel[i];
                    ++read;
                    ++i;
                }
                ri = yi + x;
                b2[ri] = cb / sum;
                ++x;
            }
            yi += this.pixelWidth;
            ++y;
        }
        yi = 0;
        int ym = -this.blurRadius;
        int ymi = ym * this.pixelWidth;
        y = 0;
        while (y < this.pixelHeight) {
            x = 0;
            while (x < this.pixelWidth) {
                sum = 0;
                cb = 0;
                if (ym < 0) {
                    bk0 = ri = -ym;
                    read = x;
                } else {
                    if (ym >= this.pixelHeight) break;
                    bk0 = 0;
                    ri = ym;
                    read = x + ymi;
                }
                i = bk0;
                while (i < this.blurKernelSize) {
                    if (ri >= this.pixelHeight) break;
                    int[] bm = this.blurMult[i];
                    cb += bm[b2[read]];
                    sum += this.blurKernel[i];
                    ++ri;
                    read += this.pixelWidth;
                    ++i;
                }
                this.pixels[x + yi] = cb / sum;
                ++x;
            }
            yi += this.pixelWidth;
            ymi += this.pixelWidth;
            ++ym;
            ++y;
        }
    }

    protected void blurRGB(float r) {
        int ri;
        int i;
        int bk0;
        int read;
        int cb;
        int cg;
        int cr;
        int sum;
        int x;
        int[] r2 = new int[this.pixels.length];
        int[] g2 = new int[this.pixels.length];
        int[] b2 = new int[this.pixels.length];
        int yi = 0;
        this.buildBlurKernel(r);
        int y = 0;
        while (y < this.pixelHeight) {
            x = 0;
            while (x < this.pixelWidth) {
                sum = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                read = x - this.blurRadius;
                if (read < 0) {
                    bk0 = -read;
                    read = 0;
                } else {
                    if (read >= this.pixelWidth) break;
                    bk0 = 0;
                }
                i = bk0;
                while (i < this.blurKernelSize) {
                    if (read >= this.pixelWidth) break;
                    int c = this.pixels[read + yi];
                    int[] bm = this.blurMult[i];
                    cr += bm[(c & 0xFF0000) >> 16];
                    cg += bm[(c & 0xFF00) >> 8];
                    cb += bm[c & 0xFF];
                    sum += this.blurKernel[i];
                    ++read;
                    ++i;
                }
                ri = yi + x;
                r2[ri] = cr / sum;
                g2[ri] = cg / sum;
                b2[ri] = cb / sum;
                ++x;
            }
            yi += this.pixelWidth;
            ++y;
        }
        yi = 0;
        int ym = -this.blurRadius;
        int ymi = ym * this.pixelWidth;
        y = 0;
        while (y < this.pixelHeight) {
            x = 0;
            while (x < this.pixelWidth) {
                sum = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                if (ym < 0) {
                    bk0 = ri = -ym;
                    read = x;
                } else {
                    if (ym >= this.pixelHeight) break;
                    bk0 = 0;
                    ri = ym;
                    read = x + ymi;
                }
                i = bk0;
                while (i < this.blurKernelSize) {
                    if (ri >= this.pixelHeight) break;
                    int[] bm = this.blurMult[i];
                    cr += bm[r2[read]];
                    cg += bm[g2[read]];
                    cb += bm[b2[read]];
                    sum += this.blurKernel[i];
                    ++ri;
                    read += this.pixelWidth;
                    ++i;
                }
                this.pixels[x + yi] = 0xFF000000 | cr / sum << 16 | cg / sum << 8 | cb / sum;
                ++x;
            }
            yi += this.pixelWidth;
            ymi += this.pixelWidth;
            ++ym;
            ++y;
        }
    }

    protected void blurARGB(float r) {
        int ri;
        int i;
        int bk0;
        int read;
        int cb;
        int cg;
        int cr;
        int ca;
        int sum;
        int x;
        int wh = this.pixels.length;
        int[] r2 = new int[wh];
        int[] g2 = new int[wh];
        int[] b2 = new int[wh];
        int[] a2 = new int[wh];
        int yi = 0;
        this.buildBlurKernel(r);
        int y = 0;
        while (y < this.pixelHeight) {
            x = 0;
            while (x < this.pixelWidth) {
                sum = 0;
                ca = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                read = x - this.blurRadius;
                if (read < 0) {
                    bk0 = -read;
                    read = 0;
                } else {
                    if (read >= this.pixelWidth) break;
                    bk0 = 0;
                }
                i = bk0;
                while (i < this.blurKernelSize) {
                    if (read >= this.pixelWidth) break;
                    int c = this.pixels[read + yi];
                    int[] bm = this.blurMult[i];
                    ca += bm[(c & 0xFF000000) >>> 24];
                    cr += bm[(c & 0xFF0000) >> 16];
                    cg += bm[(c & 0xFF00) >> 8];
                    cb += bm[c & 0xFF];
                    sum += this.blurKernel[i];
                    ++read;
                    ++i;
                }
                ri = yi + x;
                a2[ri] = ca / sum;
                r2[ri] = cr / sum;
                g2[ri] = cg / sum;
                b2[ri] = cb / sum;
                ++x;
            }
            yi += this.pixelWidth;
            ++y;
        }
        yi = 0;
        int ym = -this.blurRadius;
        int ymi = ym * this.pixelWidth;
        y = 0;
        while (y < this.pixelHeight) {
            x = 0;
            while (x < this.pixelWidth) {
                sum = 0;
                ca = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                if (ym < 0) {
                    bk0 = ri = -ym;
                    read = x;
                } else {
                    if (ym >= this.pixelHeight) break;
                    bk0 = 0;
                    ri = ym;
                    read = x + ymi;
                }
                i = bk0;
                while (i < this.blurKernelSize) {
                    if (ri >= this.pixelHeight) break;
                    int[] bm = this.blurMult[i];
                    ca += bm[a2[read]];
                    cr += bm[r2[read]];
                    cg += bm[g2[read]];
                    cb += bm[b2[read]];
                    sum += this.blurKernel[i];
                    ++ri;
                    read += this.pixelWidth;
                    ++i;
                }
                this.pixels[x + yi] = ca / sum << 24 | cr / sum << 16 | cg / sum << 8 | cb / sum;
                ++x;
            }
            yi += this.pixelWidth;
            ymi += this.pixelWidth;
            ++ym;
            ++y;
        }
    }

    protected void dilate() {
        int index = 0;
        int maxIndex = this.pixels.length;
        int[] outgoing = new int[maxIndex];
        while (index < maxIndex) {
            int curRowIndex = index;
            int maxRowIndex = index + this.pixelWidth;
            while (index < maxRowIndex) {
                int orig;
                int result = orig = this.pixels[index];
                int idxLeft = index - 1;
                int idxRight = index + 1;
                int idxUp = index - this.pixelWidth;
                int idxDown = index + this.pixelWidth;
                if (idxLeft < curRowIndex) {
                    idxLeft = index;
                }
                if (idxRight >= maxRowIndex) {
                    idxRight = index;
                }
                if (idxUp < 0) {
                    idxUp = index;
                }
                if (idxDown >= maxIndex) {
                    idxDown = index;
                }
                int colUp = this.pixels[idxUp];
                int colLeft = this.pixels[idxLeft];
                int colDown = this.pixels[idxDown];
                int colRight = this.pixels[idxRight];
                int currLum = 77 * (orig >> 16 & 0xFF) + 151 * (orig >> 8 & 0xFF) + 28 * (orig & 0xFF);
                int lumLeft = 77 * (colLeft >> 16 & 0xFF) + 151 * (colLeft >> 8 & 0xFF) + 28 * (colLeft & 0xFF);
                int lumRight = 77 * (colRight >> 16 & 0xFF) + 151 * (colRight >> 8 & 0xFF) + 28 * (colRight & 0xFF);
                int lumUp = 77 * (colUp >> 16 & 0xFF) + 151 * (colUp >> 8 & 0xFF) + 28 * (colUp & 0xFF);
                int lumDown = 77 * (colDown >> 16 & 0xFF) + 151 * (colDown >> 8 & 0xFF) + 28 * (colDown & 0xFF);
                if (lumLeft > currLum) {
                    result = colLeft;
                    currLum = lumLeft;
                }
                if (lumRight > currLum) {
                    result = colRight;
                    currLum = lumRight;
                }
                if (lumUp > currLum) {
                    result = colUp;
                    currLum = lumUp;
                }
                if (lumDown > currLum) {
                    result = colDown;
                    currLum = lumDown;
                }
                outgoing[index++] = result;
            }
        }
        System.arraycopy(outgoing, 0, this.pixels, 0, maxIndex);
    }

    protected void erode() {
        int index = 0;
        int maxIndex = this.pixels.length;
        int[] outgoing = new int[maxIndex];
        while (index < maxIndex) {
            int curRowIndex = index;
            int maxRowIndex = index + this.pixelWidth;
            while (index < maxRowIndex) {
                int orig;
                int result = orig = this.pixels[index];
                int idxLeft = index - 1;
                int idxRight = index + 1;
                int idxUp = index - this.pixelWidth;
                int idxDown = index + this.pixelWidth;
                if (idxLeft < curRowIndex) {
                    idxLeft = index;
                }
                if (idxRight >= maxRowIndex) {
                    idxRight = index;
                }
                if (idxUp < 0) {
                    idxUp = index;
                }
                if (idxDown >= maxIndex) {
                    idxDown = index;
                }
                int colUp = this.pixels[idxUp];
                int colLeft = this.pixels[idxLeft];
                int colDown = this.pixels[idxDown];
                int colRight = this.pixels[idxRight];
                int currLum = 77 * (orig >> 16 & 0xFF) + 151 * (orig >> 8 & 0xFF) + 28 * (orig & 0xFF);
                int lumLeft = 77 * (colLeft >> 16 & 0xFF) + 151 * (colLeft >> 8 & 0xFF) + 28 * (colLeft & 0xFF);
                int lumRight = 77 * (colRight >> 16 & 0xFF) + 151 * (colRight >> 8 & 0xFF) + 28 * (colRight & 0xFF);
                int lumUp = 77 * (colUp >> 16 & 0xFF) + 151 * (colUp >> 8 & 0xFF) + 28 * (colUp & 0xFF);
                int lumDown = 77 * (colDown >> 16 & 0xFF) + 151 * (colDown >> 8 & 0xFF) + 28 * (colDown & 0xFF);
                if (lumLeft < currLum) {
                    result = colLeft;
                    currLum = lumLeft;
                }
                if (lumRight < currLum) {
                    result = colRight;
                    currLum = lumRight;
                }
                if (lumUp < currLum) {
                    result = colUp;
                    currLum = lumUp;
                }
                if (lumDown < currLum) {
                    result = colDown;
                    currLum = lumDown;
                }
                outgoing[index++] = result;
            }
        }
        System.arraycopy(outgoing, 0, this.pixels, 0, maxIndex);
    }

    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.blend(this, sx, sy, sw, sh, dx, dy, dw, dh, 0);
    }

    public void copy(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.blend(src, sx, sy, sw, sh, dx, dy, dw, dh, 0);
    }

    public static int blendColor(int c1, int c2, int mode) {
        switch (mode) {
            case 0: {
                return c2;
            }
            case 1: {
                return PImage.blend_blend(c1, c2);
            }
            case 2: {
                return PImage.blend_add_pin(c1, c2);
            }
            case 4: {
                return PImage.blend_sub_pin(c1, c2);
            }
            case 8: {
                return PImage.blend_lightest(c1, c2);
            }
            case 16: {
                return PImage.blend_darkest(c1, c2);
            }
            case 32: {
                return PImage.blend_difference(c1, c2);
            }
            case 64: {
                return PImage.blend_exclusion(c1, c2);
            }
            case 128: {
                return PImage.blend_multiply(c1, c2);
            }
            case 256: {
                return PImage.blend_screen(c1, c2);
            }
            case 1024: {
                return PImage.blend_hard_light(c1, c2);
            }
            case 2048: {
                return PImage.blend_soft_light(c1, c2);
            }
            case 512: {
                return PImage.blend_overlay(c1, c2);
            }
            case 4096: {
                return PImage.blend_dodge(c1, c2);
            }
            case 8192: {
                return PImage.blend_burn(c1, c2);
            }
        }
        return 0;
    }

    public void blend(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        this.blend(this, sx, sy, sw, sh, dx, dy, dw, dh, mode);
    }

    public void blend(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        int sx2 = sx + sw;
        int sy2 = sy + sh;
        int dx2 = dx + dw;
        int dy2 = dy + dh;
        this.loadPixels();
        if (src == this) {
            if (this.intersect(sx, sy, sx2, sy2, dx, dy, dx2, dy2)) {
                this.blit_resize(this.get(sx, sy, sw, sh), 0, 0, sw, sh, this.pixels, this.pixelWidth, this.pixelHeight, dx, dy, dx2, dy2, mode);
            } else {
                this.blit_resize(src, sx, sy, sx2, sy2, this.pixels, this.pixelWidth, this.pixelHeight, dx, dy, dx2, dy2, mode);
            }
        } else {
            src.loadPixels();
            this.blit_resize(src, sx, sy, sx2, sy2, this.pixels, this.pixelWidth, this.pixelHeight, dx, dy, dx2, dy2, mode);
        }
        this.updatePixels();
    }

    private boolean intersect(int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2) {
        int sw = sx2 - sx1 + 1;
        int sh = sy2 - sy1 + 1;
        int dw = dx2 - dx1 + 1;
        int dh = dy2 - dy1 + 1;
        if (dx1 < sx1) {
            if ((dw += dx1 - sx1) > sw) {
                dw = sw;
            }
        } else {
            int w = sw + sx1 - dx1;
            if (dw > w) {
                dw = w;
            }
        }
        if (dy1 < sy1) {
            if ((dh += dy1 - sy1) > sh) {
                dh = sh;
            }
        } else {
            int h = sh + sy1 - dy1;
            if (dh > h) {
                dh = h;
            }
        }
        return dw > 0 && dh > 0;
    }

    private void blit_resize(PImage img, int srcX1, int srcY1, int srcX2, int srcY2, int[] destPixels, int screenW, int screenH, int destX1, int destY1, int destX2, int destY2, int mode) {
        block103: {
            int destOffset;
            int dy;
            int dx;
            int destH;
            int destW;
            block102: {
                if (srcX1 < 0) {
                    srcX1 = 0;
                }
                if (srcY1 < 0) {
                    srcY1 = 0;
                }
                if (srcX2 > img.pixelWidth) {
                    srcX2 = img.pixelWidth;
                }
                if (srcY2 > img.pixelHeight) {
                    srcY2 = img.pixelHeight;
                }
                int srcW = srcX2 - srcX1;
                int srcH = srcY2 - srcY1;
                destW = destX2 - destX1;
                destH = destY2 - destY1;
                boolean smooth = true;
                if (!smooth) {
                    ++srcW;
                    ++srcH;
                }
                if (destW <= 0 || destH <= 0 || srcW <= 0 || srcH <= 0 || destX1 >= screenW || destY1 >= screenH || srcX1 >= img.pixelWidth || srcY1 >= img.pixelHeight) {
                    return;
                }
                dx = (int)((float)srcW / (float)destW * 32768.0f);
                dy = (int)((float)srcH / (float)destH * 32768.0f);
                this.srcXOffset = destX1 < 0 ? -destX1 * dx : srcX1 * 32768;
                int n = this.srcYOffset = destY1 < 0 ? -destY1 * dy : srcY1 * 32768;
                if (destX1 < 0) {
                    destW += destX1;
                    destX1 = 0;
                }
                if (destY1 < 0) {
                    destH += destY1;
                    destY1 = 0;
                }
                destW = PImage.min(destW, screenW - destX1);
                destH = PImage.min(destH, screenH - destY1);
                destOffset = destY1 * screenW + destX1;
                this.srcBuffer = img.pixels;
                if (!smooth) break block102;
                this.iw = img.pixelWidth;
                this.iw1 = img.pixelWidth - 1;
                this.ih1 = img.pixelHeight - 1;
                switch (mode) {
                    case 1: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_blend(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 2: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_add_pin(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 4: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_sub_pin(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 8: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_lightest(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 16: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_darkest(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 0: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = this.filter_bilinear();
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 32: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_difference(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 64: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_exclusion(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 128: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_multiply(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 256: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_screen(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 512: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_overlay(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 1024: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_hard_light(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 2048: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_soft_light(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 4096: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_dodge(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block103;
                    }
                    case 8192: {
                        int y = 0;
                        while (y < destH) {
                            this.filter_new_scanline();
                            int x = 0;
                            while (x < destW) {
                                destPixels[destOffset + x] = PImage.blend_burn(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                                ++x;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                            ++y;
                        }
                        break block0;
                    }
                }
                break block103;
            }
            switch (mode) {
                case 1: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_blend(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 2: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_add_pin(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 4: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_sub_pin(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 8: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_lightest(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 16: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_darkest(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 0: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = this.srcBuffer[this.sY + (this.sX >> 15)];
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 32: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_difference(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 64: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_exclusion(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 128: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_multiply(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 256: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_screen(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 512: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_overlay(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 1024: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_hard_light(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 2048: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_soft_light(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 4096: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_dodge(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
                case 8192: {
                    int y = 0;
                    while (y < destH) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        int x = 0;
                        while (x < destW) {
                            destPixels[destOffset + x] = PImage.blend_burn(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                            ++x;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                        ++y;
                    }
                    break;
                }
            }
        }
    }

    private void filter_new_scanline() {
        this.sX = this.srcXOffset;
        this.fracV = this.srcYOffset & Short.MAX_VALUE;
        this.ifV = Short.MAX_VALUE - this.fracV + 1;
        this.v1 = (this.srcYOffset >> 15) * this.iw;
        this.v2 = PImage.min((this.srcYOffset >> 15) + 1, this.ih1) * this.iw;
    }

    private int filter_bilinear() {
        this.fracU = this.sX & Short.MAX_VALUE;
        this.ifU = Short.MAX_VALUE - this.fracU + 1;
        this.ul = this.ifU * this.ifV >> 15;
        this.ll = this.ifU - this.ul;
        this.ur = this.ifV - this.ul;
        this.lr = 32768 - this.ul - this.ll - this.ur;
        this.u1 = this.sX >> 15;
        this.u2 = PImage.min(this.u1 + 1, this.iw1);
        this.cUL = this.srcBuffer[this.v1 + this.u1];
        this.cUR = this.srcBuffer[this.v1 + this.u2];
        this.cLL = this.srcBuffer[this.v2 + this.u1];
        this.cLR = this.srcBuffer[this.v2 + this.u2];
        this.r = this.ul * ((this.cUL & 0xFF0000) >> 16) + this.ll * ((this.cLL & 0xFF0000) >> 16) + this.ur * ((this.cUR & 0xFF0000) >> 16) + this.lr * ((this.cLR & 0xFF0000) >> 16) << 1 & 0xFF0000;
        this.g = this.ul * (this.cUL & 0xFF00) + this.ll * (this.cLL & 0xFF00) + this.ur * (this.cUR & 0xFF00) + this.lr * (this.cLR & 0xFF00) >>> 15 & 0xFF00;
        this.b = this.ul * (this.cUL & 0xFF) + this.ll * (this.cLL & 0xFF) + this.ur * (this.cUR & 0xFF) + this.lr * (this.cLR & 0xFF) >>> 15;
        this.a = this.ul * ((this.cUL & 0xFF000000) >>> 24) + this.ll * ((this.cLL & 0xFF000000) >>> 24) + this.ur * ((this.cUR & 0xFF000000) >>> 24) + this.lr * ((this.cLR & 0xFF000000) >>> 24) << 9 & 0xFF000000;
        return this.a | this.r | this.g | this.b;
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    private static int max(int a, int b) {
        return a > b ? a : b;
    }

    private static int blend_blend(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + (src & 0xFF00FF) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + (src & 0xFF00) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_add_pin(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int rb = (dst & 0xFF00FF) + ((src & 0xFF00FF) * s_a >>> 8 & 0xFF00FF);
        int gn = (dst & 0xFF00) + ((src & 0xFF00) * s_a >>> 8);
        return PImage.min((dst >>> 24) + a, 255) << 24 | PImage.min(rb & 0xFFFF0000, 0xFF0000) | PImage.min(gn & 0xFFFF00, 65280) | PImage.min(rb & 0xFFFF, 255);
    }

    private static int blend_sub_pin(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int rb = (src & 0xFF00FF) * s_a >>> 8;
        int gn = (src & 0xFF00) * s_a >>> 8;
        return PImage.min((dst >>> 24) + a, 255) << 24 | PImage.max((dst & 0xFF0000) - (rb & 0xFF0000), 0) | PImage.max((dst & 0xFF00) - (gn & 0xFF00), 0) | PImage.max((dst & 0xFF) - (rb & 0xFF), 0);
    }

    private static int blend_lightest(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int rb = PImage.max(src & 0xFF0000, dst & 0xFF0000) | PImage.max(src & 0xFF, dst & 0xFF);
        int gn = PImage.max(src & 0xFF00, dst & 0xFF00);
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_darkest(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int rb = PImage.min(src & 0xFF0000, dst & 0xFF0000) | PImage.min(src & 0xFF, dst & 0xFF);
        int gn = PImage.min(src & 0xFF00, dst & 0xFF00);
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_difference(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int r = (dst & 0xFF0000) - (src & 0xFF0000);
        int b = (dst & 0xFF) - (src & 0xFF);
        int g = (dst & 0xFF00) - (src & 0xFF00);
        int rb = (r < 0 ? -r : r) | (b < 0 ? -b : b);
        int gn = g < 0 ? -g : g;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_exclusion(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_rb = dst & 0xFF00FF;
        int d_gn = dst & 0xFF00;
        int s_gn = src & 0xFF00;
        int f_r = (dst & 0xFF0000) >> 16;
        int f_b = dst & 0xFF;
        int rb_sub = ((src & 0xFF0000) * (f_r + (f_r >= 127 ? 1 : 0)) | (src & 0xFF) * (f_b + (f_b >= 127 ? 1 : 0))) >>> 7 & 0x1FF01FF;
        int gn_sub = s_gn * (d_gn + (d_gn >= 32512 ? 256 : 0)) >>> 15 & 0x1FF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | d_rb * d_a + (d_rb + (src & 0xFF00FF) - rb_sub) * s_a >>> 8 & 0xFF00FF | d_gn * d_a + (d_gn + s_gn - gn_sub) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_multiply(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_gn = dst & 0xFF00;
        int f_r = (dst & 0xFF0000) >> 16;
        int f_b = dst & 0xFF;
        int rb = ((src & 0xFF0000) * (f_r + 1) | (src & 0xFF) * (f_b + 1)) >>> 8 & 0xFF00FF;
        int gn = (src & 0xFF00) * (d_gn + 256) >>> 16 & 0xFF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | d_gn * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_screen(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_rb = dst & 0xFF00FF;
        int d_gn = dst & 0xFF00;
        int s_gn = src & 0xFF00;
        int f_r = (dst & 0xFF0000) >> 16;
        int f_b = dst & 0xFF;
        int rb_sub = ((src & 0xFF0000) * (f_r + 1) | (src & 0xFF) * (f_b + 1)) >>> 8 & 0xFF00FF;
        int gn_sub = s_gn * (d_gn + 256) >>> 16 & 0xFF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | d_rb * d_a + (d_rb + (src & 0xFF00FF) - rb_sub) * s_a >>> 8 & 0xFF00FF | d_gn * d_a + (d_gn + s_gn - gn_sub) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_overlay(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_r = dst & 0xFF0000;
        int d_g = dst & 0xFF00;
        int d_b = dst & 0xFF;
        int s_r = src & 0xFF0000;
        int s_g = src & 0xFF00;
        int s_b = src & 0xFF;
        int r = d_r < 0x800000 ? d_r * ((s_r >>> 16) + 1) >>> 7 : 0xFF0000 - ((256 - (s_r >>> 16)) * (0xFF0000 - d_r) >>> 7);
        int g = d_g < 32768 ? d_g * (s_g + 256) >>> 15 : 65280 - ((65536 - s_g) * (65280 - d_g) >>> 15);
        int b = d_b < 128 ? d_b * (s_b + 1) >>> 7 : 65280 - ((256 - s_b) * (255 - d_b) << 1) >>> 8;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + ((r | b) & 0xFF00FF) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + (g & 0xFF00) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_hard_light(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_r = dst & 0xFF0000;
        int d_g = dst & 0xFF00;
        int d_b = dst & 0xFF;
        int s_r = src & 0xFF0000;
        int s_g = src & 0xFF00;
        int s_b = src & 0xFF;
        int r = s_r < 0x800000 ? s_r * ((d_r >>> 16) + 1) >>> 7 : 0xFF0000 - ((256 - (d_r >>> 16)) * (0xFF0000 - s_r) >>> 7);
        int g = s_g < 32768 ? s_g * (d_g + 256) >>> 15 : 65280 - ((65536 - d_g) * (65280 - s_g) >>> 15);
        int b = s_b < 128 ? s_b * (d_b + 1) >>> 7 : 65280 - ((256 - d_b) * (255 - s_b) << 1) >>> 8;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + ((r | b) & 0xFF00FF) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + (g & 0xFF00) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_soft_light(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_r = dst & 0xFF0000;
        int d_g = dst & 0xFF00;
        int d_b = dst & 0xFF;
        int s_r1 = src & 0xFF;
        int s_g1 = src & 0xFF;
        int s_b1 = src & 0xFF;
        int d_r1 = (d_r >> 16) + ((float)s_r1 < 7.0f ? 1 : 0);
        int d_g1 = (d_g >> 8) + ((float)s_g1 < 7.0f ? 1 : 0);
        int d_b1 = d_b + ((float)s_b1 < 7.0f ? 1 : 0);
        int r = (s_r1 * d_r >> 7) + 255 * d_r1 * (d_r1 + 1) - (s_r1 * d_r1 * d_r1 << 1) & 0xFF0000;
        int g = (s_g1 * d_g << 1) + 255 * d_g1 * (d_g1 + 1) - (s_g1 * d_g1 * d_g1 << 1) >>> 8 & 0xFF00;
        int b = (s_b1 * d_b << 9) + 255 * d_b1 * (d_b1 + 1) - (s_b1 * d_b1 * d_b1 << 1) >>> 16;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + (r | b) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + g * s_a >>> 8 & 0xFF00;
    }

    private static int blend_dodge(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int r = (dst & 0xFF0000) / (256 - ((src & 0xFF0000) >> 16));
        int g = ((dst & 0xFF00) << 8) / (256 - ((src & 0xFF00) >> 8));
        int b = ((dst & 0xFF) << 8) / (256 - (src & 0xFF));
        int rb = (r > 65280 ? 0xFF0000 : r << 8 & 0xFF0000) | (b > 255 ? 255 : b);
        int gn = g > 65280 ? 65280 : g & 0xFF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_burn(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int r = (0xFF0000 - (dst & 0xFF0000)) / (1 + (src & 0xFF));
        int g = (65280 - (dst & 0xFF00) << 8) / (1 + (src & 0xFF));
        int b = (255 - (dst & 0xFF) << 8) / (1 + (src & 0xFF));
        int rb = 0xFF00FF - (r > 65280 ? 0xFF0000 : r << 8 & 0xFF0000) - (b > 255 ? 255 : b);
        int gn = 65280 - (g > 65280 ? 65280 : g & 0xFF00);
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    protected static PImage loadTIFF(byte[] tiff) {
        if (tiff[42] != tiff[102] || tiff[43] != tiff[103]) {
            System.err.println(TIFF_ERROR);
            return null;
        }
        int count = (tiff[114] & 0xFF) << 24 | (tiff[115] & 0xFF) << 16 | (tiff[116] & 0xFF) << 8 | tiff[117] & 0xFF;
        int width = (tiff[30] & 0xFF) << 8 | tiff[31] & 0xFF;
        int height = (tiff[42] & 0xFF) << 8 | tiff[43] & 0xFF;
        if (count != width * height * 3) {
            System.err.println("Error: Processing can only read its own TIFF files. (" + width + ", " + height + ")");
            return null;
        }
        int i = 0;
        while (i < TIFF_HEADER.length) {
            if (i != 30 && i != 31 && i != 42 && i != 43 && i != 102 && i != 103 && i != 114 && i != 115 && i != 116 && i != 117 && tiff[i] != TIFF_HEADER[i]) {
                System.err.println("Error: Processing can only read its own TIFF files. (" + i + ")");
                return null;
            }
            ++i;
        }
        PImage outgoing = new PImage(width, height, 1);
        int index = 768;
        count /= 3;
        int i2 = 0;
        while (i2 < count) {
            outgoing.pixels[i2] = 0xFF000000 | (tiff[index++] & 0xFF) << 16 | (tiff[index++] & 0xFF) << 8 | tiff[index++] & 0xFF;
            ++i2;
        }
        return outgoing;
    }

    protected boolean saveTIFF(OutputStream output) {
        try {
            byte[] tiff = new byte[768];
            System.arraycopy(TIFF_HEADER, 0, tiff, 0, TIFF_HEADER.length);
            tiff[30] = (byte)(this.pixelWidth >> 8 & 0xFF);
            tiff[31] = (byte)(this.pixelWidth & 0xFF);
            tiff[42] = tiff[102] = (byte)(this.pixelHeight >> 8 & 0xFF);
            tiff[43] = tiff[103] = (byte)(this.pixelHeight & 0xFF);
            int count = this.pixelWidth * this.pixelHeight * 3;
            tiff[114] = (byte)(count >> 24 & 0xFF);
            tiff[115] = (byte)(count >> 16 & 0xFF);
            tiff[116] = (byte)(count >> 8 & 0xFF);
            tiff[117] = (byte)(count & 0xFF);
            output.write(tiff);
            int i = 0;
            while (i < this.pixels.length) {
                output.write(this.pixels[i] >> 16 & 0xFF);
                output.write(this.pixels[i] >> 8 & 0xFF);
                output.write(this.pixels[i] & 0xFF);
                ++i;
            }
            output.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean saveTGA(OutputStream output) {
        header = new byte[18];
        if (this.format == 4) {
            header[2] = 11;
            header[16] = 8;
            header[17] = 40;
        } else if (this.format == 1) {
            header[2] = 10;
            header[16] = 24;
            header[17] = 32;
        } else if (this.format == 2) {
            header[2] = 10;
            header[16] = 32;
            header[17] = 40;
        } else {
            throw new RuntimeException("Image format not recognized inside save()");
        }
        header[12] = (byte)(this.pixelWidth & 255);
        header[13] = (byte)(this.pixelWidth >> 8);
        header[14] = (byte)(this.pixelHeight & 255);
        header[15] = (byte)(this.pixelHeight >> 8);
        try {
            block28: {
                output.write(header);
                maxLen = this.pixelHeight * this.pixelWidth;
                index = 0;
                currChunk = new int[128];
                if (this.format != 4) ** GOTO lbl109
                while (index < maxLen) {
                    isRLE = false;
                    rle = 1;
                    currChunk[0] = col = this.pixels[index] & 255;
                    while (index + rle < maxLen) {
                        if (col != (this.pixels[index + rle] & 255) || rle == 128) {
                            isRLE = rle > 1;
                            break;
                        }
                        ++rle;
                    }
                    if (isRLE) {
                        output.write(128 | rle - 1);
                        output.write(col);
                    } else {
                        rle = 1;
                        while (index + rle < maxLen) {
                            cscan = this.pixels[index + rle] & 255;
                            if ((col == cscan || rle >= 128) && rle >= 3) {
                                if (col != cscan) break;
                                rle -= 2;
                                break;
                            }
                            currChunk[rle] = col = cscan;
                            ++rle;
                        }
                        output.write(rle - 1);
                        i = 0;
                        while (i < rle) {
                            output.write(currChunk[i]);
                            ++i;
                        }
                    }
                    index += rle;
                }
                break block28;
lbl-1000:
                // 1 sources

                {
                    isRLE = false;
                    currChunk[0] = col = this.pixels[index];
                    rle = 1;
                    while (index + rle < maxLen) {
                        if (col != this.pixels[index + rle] || rle == 128) {
                            isRLE = rle > 1;
                            break;
                        }
                        ++rle;
                    }
                    if (isRLE) {
                        output.write(128 | rle - 1);
                        output.write(col & 255);
                        output.write(col >> 8 & 255);
                        output.write(col >> 16 & 255);
                        if (this.format == 2) {
                            output.write(col >>> 24 & 255);
                        }
                    } else {
                        rle = 1;
                        while (index + rle < maxLen) {
                            if ((col == this.pixels[index + rle] || rle >= 128) && rle >= 3) {
                                if (col != this.pixels[index + rle]) break;
                                rle -= 2;
                                break;
                            }
                            currChunk[rle] = col = this.pixels[index + rle];
                            ++rle;
                        }
                        output.write(rle - 1);
                        if (this.format == 2) {
                            i = 0;
                            while (i < rle) {
                                col = currChunk[i];
                                output.write(col & 255);
                                output.write(col >> 8 & 255);
                                output.write(col >> 16 & 255);
                                output.write(col >>> 24 & 255);
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < rle) {
                                col = currChunk[i];
                                output.write(col & 255);
                                output.write(col >> 8 & 255);
                                output.write(col >> 16 & 255);
                                ++i;
                            }
                        }
                    }
                    index += rle;
lbl109:
                    // 2 sources

                    ** while (index < maxLen)
                }
            }
            output.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean saveImageIO(String path) throws IOException {
        File file;
        BufferedImage bimage;
        String extension;
        block6: {
            try {
                int outputFormat = this.format == 2 ? 2 : 1;
                extension = path.substring(path.lastIndexOf(46) + 1).toLowerCase();
                if (extension.equals("bmp") || extension.equals("jpg") || extension.equals("jpeg")) {
                    outputFormat = 1;
                }
                bimage = new BufferedImage(this.pixelWidth, this.pixelHeight, outputFormat);
                bimage.setRGB(0, 0, this.pixelWidth, this.pixelHeight, this.pixels, 0, this.pixelWidth);
                file = new File(path);
                ImageWriter writer = null;
                ImageWriteParam param = null;
                IIOMetadata metadata = null;
                if ((extension.equals("jpg") || extension.equals("jpeg")) && (writer = this.imageioWriter("jpeg")) != null) {
                    param = writer.getDefaultWriteParam();
                    param.setCompressionMode(2);
                    param.setCompressionQuality(0.9f);
                }
                if (extension.equals("png") && (writer = this.imageioWriter("png")) != null) {
                    param = writer.getDefaultWriteParam();
                }
                if (writer == null) break block6;
                BufferedOutputStream output = new BufferedOutputStream(PApplet.createOutput(file));
                writer.setOutput(ImageIO.createImageOutputStream(output));
                writer.write(metadata, new IIOImage(bimage, null, metadata), param);
                writer.dispose();
                output.flush();
                output.close();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("image save failed.");
            }
        }
        return ImageIO.write((RenderedImage)bimage, extension, file);
    }

    private ImageWriter imageioWriter(String extension) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(extension);
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    private IIOMetadata imageioDPI(ImageWriter writer, ImageWriteParam param, double dpi) {
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, param);
        if (!metadata.isReadOnly() && metadata.isStandardMetadataFormatSupported()) {
            double dotsPerMilli = dpi / 25.4;
            IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
            horiz.setAttribute("value", Double.toString(dotsPerMilli));
            IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
            vert.setAttribute("value", Double.toString(dotsPerMilli));
            IIOMetadataNode dim = new IIOMetadataNode("Dimension");
            dim.appendChild(horiz);
            dim.appendChild(vert);
            IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
            root.appendChild(dim);
            try {
                metadata.mergeTree("javax_imageio_1.0", root);
                return metadata;
            }
            catch (IIOInvalidTreeException e) {
                System.err.println("Could not set the DPI of the output image");
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(String filename) {
        boolean success = false;
        if (this.parent != null) {
            filename = this.parent.savePath(filename);
        } else {
            File file = new File(filename);
            if (file.isAbsolute()) {
                PApplet.createPath(file);
            } else {
                String msg = "PImage.save() requires an absolute path. Use createImage(), or pass savePath() to save().";
                PGraphics.showException(msg);
            }
        }
        this.loadPixels();
        try {
            BufferedOutputStream os = null;
            if (this.saveImageFormats == null) {
                this.saveImageFormats = ImageIO.getWriterFormatNames();
            }
            if (this.saveImageFormats != null) {
                int i = 0;
                while (i < this.saveImageFormats.length) {
                    if (filename.endsWith("." + this.saveImageFormats[i])) {
                        if (this.saveImageIO(filename)) return true;
                        System.err.println("Error while saving image.");
                        return false;
                    }
                    ++i;
                }
            }
            if (filename.toLowerCase().endsWith(".tga")) {
                os = new BufferedOutputStream(new FileOutputStream(filename), 32768);
                success = this.saveTGA(os);
            } else {
                if (!filename.toLowerCase().endsWith(".tif") && !filename.toLowerCase().endsWith(".tiff")) {
                    filename = String.valueOf(filename) + ".tif";
                }
                os = new BufferedOutputStream(new FileOutputStream(filename), 32768);
                success = this.saveTIFF(os);
            }
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            return success;
        }
        catch (IOException e) {
            System.err.println("Error while saving image.");
            e.printStackTrace();
            return false;
        }
    }
}

