
#!/usr/bin/python
#####################################################################################################################################
# Created by Martin Viljoen 2015/11/14                                                                                              #
# V1.00, Raspberry PI Griblinks Script register @ www.techtinker.co.za/griblinks                                                    #
# Fetch URL: http://www.techtinker.co.za/griblinks/getswstatusrpi.php                                                               #
#                                                                                                                                   #
# Usage: getswstatusrpi.php?EMAIL=email_address&SECRET=secret_code_from_griblinks_account_profile                                   #
#                                                                                                                                   #
# Information:                                                                                                                      #
# getswstatusrpi.php will return a series of switch statuses seperated by a comma, each switch status                               #
# is then further split by a :                                                                                                      #
# | = Turns IO Pins ON                                                                                                              #
# ~ = Turns IO Pins Off                                                                                                             #
#                                                                                                                                   #
# Confusion Alert!                                                                                                                  #
# You will note that Griblinks will allow you to enable and disable pins 2 to 9                                                     # 
# Originally Griblinks was developed for Arduino when using the Arduino Network Shiled pin 2 to 9 are available the other pins      #
# were used by the network shield it self.                                                                                          #
#                                                                                                                                   #
#####################################################################################################################################


#Imports
import urllib #Import the URL library allowing you to communicate with a web server
import RPi.GPIO as GPIO #import GPIO library
import threading #Import timer library , used to loop the script every X seconds
import os #import operating system functions (Used to clear the screen)

#Setup & Init Raspberry GPIO Pins
GPIO.setmode(GPIO.BCM)
GPIO.setwarnings(False) #Disable if pins were already initialized
#SET Pin Number outputs
GPIO.setup(17, GPIO.OUT)
GPIO.setup(18, GPIO.OUT)
GPIO.setup(21, GPIO.OUT)
GPIO.setup(22, GPIO.OUT)
GPIO.setup(23, GPIO.OUT)
GPIO.setup(24, GPIO.OUT)
GPIO.setup(10, GPIO.OUT)
GPIO.setup(25, GPIO.OUT)

#Loop script every X seconds
def printit():
	threading.Timer(10.0, printit).start()
	os.system('clear')  # on linux / os x

 
	#Fetch the pinstatuses using your email and security key
	url = "http://www.techtinker.co.za/griblinks/getswstatusrpi.php?EMAIL=mailmartinviljoen@gmail.com&SECRET=AFD11R0srCUWpHt8jp7j"
	response = urllib.urlopen(url).read()
	
	
	# Separate switch values using a comma.
	
	switches= response.split(",")
	
	#Define Switch Values
	swvalues=[0,1,2,3,4,5,6,7,8,9]
	#GET Switch values from each switch array
	swvalues[2]=switches[2].split(":")
	swvalues[3]=switches[3].split(":")
	swvalues[4]=switches[4].split(":")
	swvalues[5]=switches[5].split(":")
	swvalues[6]=switches[6].split(":")
	swvalues[7]=switches[7].split(":")
	swvalues[8]=switches[8].split(":")
	swvalues[9]=switches[9].split(":")
	
	#DEBUG: Uncomment hashes to print out each switch value
	#print response
	print "#####################################"
	print "#V1.00 R-PI Griblinks Script       #"
	print "# Switch Statuses | = ON & ~ = OFF #"
	print "####################################"
	print swvalues[2][0] + " Value = " + swvalues[2][1]
	print swvalues[3][0] + " Value = " + swvalues[3][1]
	print swvalues[4][0] + " Value = " + swvalues[4][1]
	print swvalues[5][0] + " Value = " + swvalues[5][1]
	print swvalues[6][0] + " Value = " + swvalues[6][1]
	print swvalues[7][0] + " Value = " + swvalues[7][1]
	print swvalues[8][0] + " Value = " + swvalues[8][1]
	print swvalues[9][0] + " Value = " + swvalues[9][1]
	print "####################################"
	
	#For some reason the below wont work
	#if swvalues[2][1]=="|":GPIO.output(17, GPIO.HIGH) else: GPIO.output(17, GPIO.LOW)	
	#if swvalues[3][1]=="|":GPIO.output(18, GPIO.HIGH) else: GPIO.output(18, GPIO.LOW)
	#if swvalues[4][1]=="|":GPIO.output(21, GPIO.HIGH) else: GPIO.output(21, GPIO.LOW)
	#if swvalues[5][1]=="|":GPIO.output(22, GPIO.HIGH) else: GPIO.output(22, GPIO.LOW)
	#if swvalues[6][1]=="|":GPIO.output(23, GPIO.HIGH) else: GPIO.output(23, GPIO.LOW)
	#if swvalues[7][1]=="|":GPIO.output(24, GPIO.HIGH) else: GPIO.output(24, GPIO.LOW)
	#if swvalues[8][1]=="|":GPIO.output(10, GPIO.HIGH) else: GPIO.output(10, GPIO.LOW)
	#if swvalues[9][1]=="|":GPIO.output(25, GPIO.HIGH) else: GPIO.output(25, GPIO.LOW)
	#Working around the above issue in a very stupid way!!!
	#If swValues[X] = "|" switch on pins.
	if swvalues[2][1]=="|":GPIO.output(17, GPIO.HIGH)
	if swvalues[3][1]=="|":GPIO.output(18, GPIO.HIGH)
	if swvalues[4][1]=="|":GPIO.output(21, GPIO.HIGH)
	if swvalues[5][1]=="|":GPIO.output(22, GPIO.HIGH)
	if swvalues[6][1]=="|":GPIO.output(23, GPIO.HIGH)
	if swvalues[7][1]=="|":GPIO.output(24, GPIO.HIGH)
	if swvalues[8][1]=="|":GPIO.output(10, GPIO.HIGH)
	if swvalues[9][1]=="|":GPIO.output(25, GPIO.HIGH)
	#If swValues[X] = "~" switch off pins.
	if swvalues[2][1]=="~":GPIO.output(17, GPIO.LOW)
	if swvalues[3][1]=="~":GPIO.output(18, GPIO.LOW)
	if swvalues[4][1]=="~":GPIO.output(21, GPIO.LOW)
	if swvalues[5][1]=="~":GPIO.output(22, GPIO.LOW)
	if swvalues[6][1]=="~":GPIO.output(23, GPIO.LOW)
	if swvalues[7][1]=="~":GPIO.output(24, GPIO.LOW)
	if swvalues[8][1]=="~":GPIO.output(10, GPIO.LOW)
	if swvalues[9][1]=="~":GPIO.output(25, GPIO.LOW)
	
printit()







  














    



