// wake up turns on

void wakeUpNow()        // Required for the interrupt for waking up
{
  // No code will be run here
}

void sleepNow()
{
  // Disable outputs.
  pinMode(redPwmPin, INPUT);
  pinMode(yellowPwmPin, INPUT);
  pinMode(bluePwmPin, INPUT);

  prevMillis=millis(); // Reset the timer.


  // Go to sleep
  adc_disable(); // Disable ADC to save energy
  set_sleep_mode(SLEEP_MODE_PWR_DOWN);   // Sleep mode with the most power saving
  sleep_enable();          // enables the sleep bit in the mcucr register
  attachInterrupt(0, wakeUpNow, LOW); // use interrupt 0 (pin 2) and run function
  sleep_mode();     // The chip is put to sleep here

  // Wake up
  sleep_disable(); // When button is pressed, wake up
  detachInterrupt(0); // disables interrupt 0 on pin 2 to prevent executing wakeUpNow while running
  adc_enable();

  delayCounts = 0;

  buttonPinState = digitalRead(buttonPin);

  while (buttonPinState == LOW) {
    delay(debounceDelay);
    delayCounts++;
    buttonPinState = digitalRead(buttonPin);
  }

  if (delayCounts <= 2) {
    sleepNow();
  }

  // Re-enable outputs.
  pinMode(redPwmPin, OUTPUT);
  pinMode(yellowPwmPin, OUTPUT);
  pinMode(bluePwmPin, OUTPUT);
  timeSwPinState = digitalRead(timeSwPin);

  // Set the time after waking up.
  if (timeSwPinState == HIGH) { 
    duration = 90000; // 15 min.
    //duration = 5000; // Testing only.
  }
  else {
    duration = 2700000; // 45 min.
    //duration = 20000; // Testing only.
  }

}

