/*
 *  Timer and dimmer program for the visor mounted light therapy lamp.
 *  
 *  Features:
 *  Brightness can be adjusted (25% or 100%).
 *  Timer can be adjusted (15 min or 45 min).
 *  Clicking the button or low battery puts the lamp to sleep.
 *  Pressing the button resets or turns on the lamp.
 *  Battery cut-off voltage of 7.7V used. 9V battery should have a nominal voltage of 8.4V. 
 * 
 */

#include <avr/sleep.h>

// Utility macros
#define adc_disable() (ADCSRA &= ~(1<<ADEN)) // disable ADC
#define adc_enable()  (ADCSRA |=  (1<<ADEN)) // re-enable ADC

int buttonPin = 8;
int redPwmPin = 7;
int yellowPwmPin = 6;
int bluePwmPin = 5;
int redSwPin = 4;
int yellowSwPin = 3;
int timeSwPin = 2;
int blueSwPin = 1;
int batteryMonitorPin = 0;

int batteryMonitorReading;
boolean buttonPinState;
boolean redSwPinState;
boolean yellowSwPinState;
boolean blueSwPinState;
boolean timeSwPinState;

int redBrightness, yellowBrightness, blueBrightness;
unsigned long duration;
unsigned long elapsedMillis;
unsigned long prevMillis;
int delayCounts;
int debounceDelay = 300;

void setup() {
  // put your setup code here, to run once:
  pinMode(buttonPin, INPUT_PULLUP);
  pinMode(redSwPin, INPUT_PULLUP);
  pinMode(yellowSwPin, INPUT_PULLUP);
  pinMode(blueSwPin, INPUT_PULLUP);
  pinMode(timeSwPin, INPUT_PULLUP);
  pinMode(batteryMonitorPin, INPUT);
}

void loop() {
  buttonPinState = digitalRead(buttonPin);
  redSwPinState = digitalRead(redSwPin);
  yellowSwPinState = digitalRead(yellowSwPin);
  blueSwPinState = digitalRead(blueSwPin);
  batteryMonitorReading=analogRead(batteryMonitorPin);

  // Set the brightness levels of each colour.
  if (redSwPinState == HIGH) {
    redBrightness = 63;
  }
  else {
    redBrightness = 255;
  }

  if (yellowSwPinState == HIGH) {
    yellowBrightness = 63;
  }
  else {
    yellowBrightness = 255;
  }
  if (blueSwPinState == HIGH) {
    blueBrightness = 63;
  }
  else {
    blueBrightness = 255;
  }
  analogWrite(redPwmPin, redBrightness);
  analogWrite(yellowPwmPin, yellowBrightness);
  analogWrite(bluePwmPin, blueBrightness);

  elapsedMillis = millis() - prevMillis;
  if (elapsedMillis > duration) { // If timer is up, go to sleep.
    sleepNow();
  }
  
  if (buttonPinState == LOW) { // If button is pressed, go to sleep.
    sleepNow();
  }
  
  if(batteryMonitorReading<390){ // Cut-off of 7.7V for an 8.4V battery. 5V reference used for ADC.
    sleepNow();
  }
}
