/*
  musical t-shirt
  with smoothing
  LilyPad USB as USB keyboard
  using Soundplant http://soundplant.org/
*/

#include "Keyboard.h"

const int pushButton = 2;
const int vibeBoard = 11;
const int inputPin = A5;

const int numReadings = 10;

int readings[numReadings];      // the readings from the analog input
int readIndex = 0;              // the index of the current reading
int total = 0;                  // the running total
int average = 0;                // the average


void setup() {

  pinMode(pushButton, INPUT_PULLUP);
  pinMode(vibeBoard, OUTPUT);

  // initialize serial communication with computer:
  Serial.begin(9600);

  // initialize all the readings to 0:
  for (int thisReading = 0; thisReading < numReadings; thisReading++) {
    readings[thisReading] = 0;

    Keyboard.begin();
  }
}

void loop() {

  int buttonState = digitalRead(pushButton);

  // do not process flex sensor data
  // or use LilyPad USB as keyboard
  // until switch is closed
  if (buttonState == LOW) {

    // subtract the last reading:
    total = total - readings[readIndex];
    // read from the sensor:
    readings[readIndex] = analogRead(inputPin);
    // add the reading to the total:
    total = total + readings[readIndex];
    // advance to the next position in the array:
    readIndex = readIndex + 1;

    // if we're at the end of the array...
    if (readIndex >= numReadings) {
      // ...wrap around to the beginning:
      readIndex = 0;
    }

    // calculate the average:
    average = total / numReadings;
    // send it to the computer as ASCII digits
    Serial.println(average);

    if (average > 250) {
      Serial.println("play");
      Keyboard.press('n');
      delay(100);
      Keyboard.releaseAll();
      digitalWrite(vibeBoard, HIGH);

      delay(1);        // delay in between reads for stability
    } else if (average < 580) {
      digitalWrite(vibeBoard, LOW);
    }

  }
}


