import processing.serial.*;
Serial myPort;  // Create object from Serial class
PImage IMG; //create a PImage named IMG

void setup() {
  size(60, 118);//Put here the size of your image
  String portName = Serial.list()[0];
  myPort = new Serial(this, portName, 9600);//opens the Serial Port
  IMG = loadImage("link2.jpg");//Open your image.
  image(IMG, 0, 0);
}
void draw() {
  IMG.loadPixels(); 
  for (int y = 0; y < height; y++) {//check the lines
    for (int x = 0; x < width; x++) { //check each pixel in the line
      int loc = x + y*width; //the pixels are loaded as in a aray, so its position is only a number.
      if (IMG.pixels[loc]>color(128)) {
        myPort.write(0);//if a pixel is not black, send a '0'.
        delay(50);
      }
      else {
        myPort.write(1);//if a pixel is black, send a '1'.  
        delay(50);
      }
    }
    delay(10000);//Wait for some time, time enough to the printer finish this line.
    myPort.write('L');//send a "L" to indicate a new line.
  }
  noLoop();
}

