#include "C:\projects\pic\PIC18LF1220\PIC\a.h"

// 3 channel software PWM driver
// blanking signal with variable frequency
// 
// timer0 - PWM period 
// timer1 - short time intervals
//	interval  IDutyInc - between duty increment in auto mode(fading)  	- 0.13 S
// timer3 - long time intervals
//  interval  IState - between state switching in auto mode  			- 60 S

//void rand_duty(int &r, int &rN);
void rand_dutyA(int &r, int &rN);
void rand_dutyB(int &r, int &rN);
void rand_dutyC(int &r, int &rN);

// using pins

// analog inputs 
// A0 - analog input 1
// A1 - analog input 2
// A2 - analog input 3
//
// controlled outputs
// B3
// B2
// A7
//
// !!!! test output !!!!
// B0
//
// blanking signal
// B1
//
// mode switch
// A4


//#define test_pin PIN_A3 
#define test_pin PIN_B0 

#define channel_A_pin PIN_B3
#define channel_B_pin PIN_B2 
#define channel_C_pin PIN_A7 

#define analog_A 0
#define analog_B 1
#define analog_C 2 

#define mode_switch_pin PIN_A4

#define blanking_pin PIN_B1
int blanking = 0;
int blanking_set = 255;

// global variable 
// logic flag for test purpose
boolean k = 0;

// logic flag - time interval IDutyInc has passed
//(duty value increasing in auto mode)
boolean fDutyInc = 0;


//address of duty value in EEPROM
BYTE address_duty=0;

//duty values
int A_duty=80;
int B_duty=182;
int C_duty=61;
int A_dutyNew=32;
int B_dutyNew=64;
int C_dutyNew=128;

//current value of timer 0 (PWM period)
int pwm_tik = 0;
//current time value from timer(long interval)
int current_time = 0;		//time interval for EEPROM write (1S) 
int long_time = 0;			//fast duty switching
int16 state_time = 0;		//time constant for state mashine
//period is equal LONG_PERIOD * timer3 period 
#define LONG_PERIOD 100		//10 Sec	time period between duty switching(fast switch)
#define STATE_PERIOD 600	//60 Sec time period between state switching(fading-switching)	

//timer0 preset 
#define timer0_preset 127

//timer1 preset 
#define timer1_preset 40535

//timer preset value to control period of timer
//int16 timer_preset = 0;

//states in auto mode 
// 0 - fading 
// 1 - fast switch
// 2 - slow switch
int state = 0;

// mode switch
// 0 - manual set of duty's value through ADC reading 
// 1 - auto 
boolean mode;


// PWM period
#int_RTCC  high 
void RTCC_isr()
{

set_timer0(timer0_preset);

//output_toggle(test_pin);


	pwm_tik++;

	
	if(pwm_tik == 0)
	{
		output_high(channel_A_pin);
		output_high(channel_B_pin);
		output_high(channel_C_pin);

	}
	else
	{
		{

			if(pwm_tik >= A_duty)
			{
				output_low (channel_A_pin);
			}
			if(pwm_tik >= B_duty)
			{
				output_low (channel_B_pin);
			}
			if(pwm_tik >= C_duty)
			{
				output_low (channel_C_pin);
			}
		}
	}
}

// timer1 - short time intervals between modifying of duty value
//

#int_TIMER1 //noclear
void TIMER1_isr() 
{
	set_timer1(timer1_preset);	//period 0.1S

	//read current mode  
	mode = input(mode_switch_pin); 
	fDutyInc = 1;	//duty increment must be done
}

//#int_TIMER3
//void TIMER3_isr()
//{
//}

//#int_EEPROM
//void EEPROM_isr()
//{
//}


void main()
{

  	byte valueA;
  	byte valueB;
  	byte valueC;

	int s123 = 0;
	int b123 = 0;

    setup_oscillator(OSC_8MHZ); 
   	setup_adc(ADC_CLOCK_INTERNAL|ADC_TAD_MUL_0);
	setup_adc_ports(sAN0|sAN1|sAN2|VSS_VDD);

   	setup_wdt(WDT_OFF);
	setup_ccp1(CCP_OFF);
	
	//timer0 - PMW period
	//timer0 is configured as an 8-bit timer/counter
	//period = Tosc * 4 * Prescaler * 256 = 0.125 uS * 4 * 64 * 256 = 8.192mS
	//PWM frequency - 122Hz
	setup_timer_0(RTCC_INTERNAL|RTCC_DIV_1|RTCC_8_BIT); 
	set_timer0(timer0_preset);		//period 48	uS, 48uS * 256 = 12.288 mS
 
	//timer1 short time intervals
	//period = Tosc * 4 * Prescaler * 65536 = 0.125 uS * 4 * 4 * 65536 = 0.1310172S
	setup_timer_1( T1_INTERNAL | T1_DIV_BY_8 );
	set_timer1(timer1_preset);	//40535 period =0.1S

	//timer1 long time intervals
	//period = Tosc * 4 * Prescaler * 65536 = 0.125 uS * 4 * 8 * 65536 = 0.262144S
	setup_timer_3(T3_DISABLED);
	//setup_timer_3( T1_INTERNAL | T1_DIV_BY_8 );

   	setup_timer_2(T2_DISABLED,0,1);
	enable_interrupts(INT_TIMER1);
//	enable_interrupts(INT_TIMER3);
	enable_interrupts(INT_TIMER0);
//	enable_interrupts(INT_EEPROM);

	enable_interrupts(GLOBAL);


	valueA = read_EEPROM(address_duty); 
	if(valueA !=0) 
	{
		A_duty = valueA; 
		rand_dutyA(A_duty,A_dutyNew);
	}
	valueB = read_EEPROM(address_duty+1); 
	if(valueB !=0) 
	{
		B_duty = valueB;	
		rand_dutyB(B_duty,B_dutyNew);
	}
 	valueC = read_EEPROM(address_duty+2); 
	if(valueC !=0) 
	{
		C_duty = valueC;
		rand_dutyC(C_duty,C_dutyNew);
	}




	for(;;)
	{


		blanking++;
		if(blanking==blanking_set)	
		{
			blanking = 0;
			output_toggle(blanking_pin);
		}



		//short time period (duty increment, ADC reading) 
		if(fDutyInc)
		{
			fDutyInc = 0;


			long_time++;	//long time interval(duty switching)
			state_time++;	//time interval for state machine
			current_time++;

			//state period - 60S
			if(state_time == STATE_PERIOD)
			{
				state_time = 0;

				switch(state) {
					case 0:
						state = 1;
					break;
					case 1:
						state = 0;
					break;
				}
			}


			if(mode) 
			//==============================//
			// 1 - auto mode                // 
			//==============================//

			{

			//state machine (fading - switching)
			switch(state) {
	
				//fading
	
				case 0:

						if(A_duty != A_dutyNew) {
							if(A_duty<A_dutyNew) A_duty++;
							else A_duty--;
						}
						else
						{
							rand_dutyA(A_duty,A_dutyNew);
//							write_EEPROM(address_duty,A_dutyNew);			
						}

						if(B_duty != B_dutyNew) {
							if(B_duty<B_dutyNew) B_duty++;
							else B_duty--;
						}
						else
						{
							rand_dutyB(B_duty,B_dutyNew);
//							write_EEPROM(address_duty+1,B_dutyNew);			
						}


						if(C_duty != C_dutyNew) {
							if(C_duty<C_dutyNew) C_duty++;
							else C_duty--;
						}
						else
						{
							rand_dutyC(C_duty,C_dutyNew);
//							write_EEPROM(address_duty+2,C_dutyNew);			
						}

				break;

				//fast switching
				case 1:

					//svitching period - 10S
					if(long_time == LONG_PERIOD)
					{
						long_time = 0;

						rand_dutyA(A_duty,A_dutyNew);
//						write_EEPROM(address_duty,A_dutyNew);
						A_duty = A_dutyNew;

						rand_dutyB(B_duty,B_dutyNew);
//						write_EEPROM(address_duty+1,B_dutyNew);
						B_duty = B_dutyNew;

						rand_dutyC(C_duty,C_dutyNew);
//						write_EEPROM(address_duty+2,C_dutyNew);
						C_duty = C_dutyNew;
					}//end if(long_time == LONG_PERIOD)
				break;
			
				case 2:
				break;
			}	//end of switch(state)

			}//if(mode)


			//==============================//
			// 0 - manual mode              // 
			//==============================//

			else
			{
				//read ADC inputs and modify duty values

				set_adc_channel( analog_A );
				delay_us(10);
				A_duty = read_adc();
				
				//duty value cannot be equal 0 because random generator will return 0
				if(!A_duty)
				{
					A_duty = 1;	
				}
//				write_EEPROM(address_duty,A_duty);			

				set_adc_channel( analog_B );
				delay_us(10);
				B_duty = read_adc();
				if(!B_duty)
				{
					B_duty = 1;	
				}
//				write_EEPROM(address_duty+1,B_duty);			

				set_adc_channel( analog_C );
				delay_us(10);
				C_duty = read_adc();
				if(!C_duty)
				{
					C_duty = 1;	
				}
//				write_EEPROM(address_duty+2,C_duty);	


	
			}//else(mode)
	
			//write current data into EEPROM memory
			//writing procedure CANNOT be interrupted!!!
			//delay is several mS (5mS)
			if(current_time == 10)
			{

				output_toggle(test_pin);

				current_time = 0;
				switch(s123)
				{
					case 0:
						s123 = 1;
						write_EEPROM(address_duty,A_duty);			
					break;
					case 1:
						s123 = 2;
						write_EEPROM(address_duty+1,B_duty);			
					break;
					case 2:
						s123 = 0;
						write_EEPROM(address_duty+2,C_duty);	
					break;
				}

//------------------------------
			switch(b123)
			{
				case 0:
					b123 = 1;
					if(A_duty>1)
					blanking_set = A_duty;
				break;
				case 1:
					b123 = 2;
					if(B_duty>1)
					blanking_set = B_duty;
				break;
				case 2:
					b123 = 0;
					if(C_duty>1)
					blanking_set = C_duty;
				break;
			}

//--------------------------------		

			}//if(current_time

		}//if(fDutyInc)

	}//for
 
}


void rand_dutyA(int &r, int &rN){
	//value cannot be equal 0 !!!
	if(!r) r = 1;
	rN = r;
	//only one motor at the time can be stopped 	
	if(B_duty > 64 && C_duty > 64)
	{
		shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));	
	}
	//omit duty values less than 64 (motor will not spin)
	else
	{
		do
		{
			shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));
		}	while (rN<=64);
	}
}
void rand_dutyB(int &r, int &rN){
	//value cannot be equal 0 !!!
	if(!r) r = 1;
	rN = r;
	//only one motor at the time can be stopped 	
	if(A_duty > 64 && C_duty > 64)
	{
		shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));	
	}
	//omit duty values less than 64 (motor will not spin)
	else
	{
		do
		{
			shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));
		}	while (rN<=64);
	}
}
void rand_dutyC(int &r, int &rN){
	//value cannot be equal 0 !!!
	if(!r) r = 1;
	rN = r;
	//only one motor at the time can be stopped 	
	if(B_duty > 64 && A_duty > 64)
	{
		shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));	
	}
	//omit duty values less than 64 (motor will not spin)
	else
	{
		do
		{
			shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));
		}	while (rN<=64);
	}
}

