/* FluxamasynthDrumPatternPlayer.pde
* A drum machine for the Modern Device Fluxamasynth Shield
* ModernDevice.com
*
* By Michel Gutlich 26-2-2011 
* A sensor signal on analog input 0 gives some tempo dynamics
* Contact at iching@xs4al.nl
*/

#include <Fluxamasynth.h>
#include <PgmChange.h>
#include <RunningMedian.h>
#include <shit>
#include <SPI.h>
#include <TCL.h>


# define bass 36              // Define midi note numbers for several GM drum sounds
# define snare 38
# define hihatC 42
# define hihatP 44
# define hihatO 46
# define synthbass 38
# define lead 33


//setup constants for LEDs
const int LEDS = 16; // There are 16 LEDs
//byte red[] = {0x00, 0x00, 0x00, 0x00, 0x00};
//byte green[] = {0x00, 0x00, 0x00, 0x00, 0x00};
//byte blue[] = {0x00, 0x00, 0x00, 0x00, 0x00};

byte red[16];
byte green[16]; 
byte blue[16]; 

long previousMillis = 0; //variable for timing music
long previousMillisFade = 0; //variable for timing fade
long fadeInterval = 30;
int fadeDir = 1;
long contStartTime = 0;
long lightStart = 0;
int barCount = 1;
int sampleTimeDone = 0;
long killcounter = 0;
int killFlag = 0;//enabled when contact is dropped

int leadno = 0;


RunningMedian samples = RunningMedian();

unsigned long pTime[30];
int pTimeIx = -1;
unsigned long pTimeCur = 0;
long pTimePrev = 0;
int pTimeDiff=0;
int interval = 120;
int enableMusic = 0;
int halfSecondCount = 0;
int recordFlag = 0;
int prerecordFlag = 0;
int musicStart = 0;
int lockedBPM = 0;
int patternNo = 0;
int fadeCount = 0;//counter for fading
int instr;//variable for instrument

Fluxamasynth synth;		// create a synth object

/* **** Our drum pattern ***/
int patternSize = 16;         // A pattern of max 16 ticks ( actualy 15, because we loop and 16 is tick no. 1....you dig it ? )

// Every array cell is the velocity of the note played 
// Tick         1   2   3   4   5   6   7   8   9  10  11  12  13  14  15
//int bd  [] = {127,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 90,  0}; //Bassdrum
//int sn  [] = {  0,  0,  0,  0,127,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0}; //Snare
//int hho [] = {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,127,  0}; //Hihat Open
//int hhc [] = {127, 40, 80, 40,127, 40, 80, 40,127, 40, 80, 40,127,  0,  0}; //Hihat Close
//int hhp [] = {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,127}; //Hihat Pedal
//int a = 127;

// Tick 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
int hb[6][16];
int bd[6][16];
int sn[6][16];
int hho[6][16];
int hhc[6][16];
int hhp[6][16];

int leadpat1[5][16];
int leadpat2[5][16];
//Rich's patterns
// Default Patter0. Every array cell is the velocity of the note played
// Tick 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
int hb0 [] = {0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127}; //heartbeat
int bd0 [] = {127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 0, 0}; //Bassdrum
int sn0 [] = { 0, 0, 0, 0,127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; //Snare
int hho0 [] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,127, 0, 0}; //Hihat Open
int hhc0 [] = {127, 40, 80, 40,127, 40, 80, 40,127, 40, 80, 40,127, 0, 0, 0}; //Hihat Close
int hhp0 [] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,127, 0}; //Hihat Pedal


// DDT pattern1 "HeartBeat"
// Tick 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
int hb1 [] = {0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127}; //heartbeat
int bd1 [] = {127, 0, 0, 0, 0, 0, 0, 0,127, 0, 0, 0, 0, 0,127, 0}; //Bassdrum
int sn1 [] = { 0,127, 0, 0,127, 0,127, 0, 0, 0, 0,127, 0, 0, 0,127}; //Snare +16
int hho1 [] = { 0,127, 0, 0, 0, 0, 0, 0,127, 0, 0,127, 0, 0,127, 0}; //Hihat Open
int hhc1 [] = { 0, 0,127,127, 0,127, 0,127, 0, 0, 0,127, 0,127, 0,127}; //Hihat Close +16
int hhp1 [] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,127, 0,127, 0, 0, 0}; //Hihat Pedal


// DDT pattern2 "BunkerBeat"
// Tick 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
int hb2 [] = {0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127}; //heartbeat
int bd2 [] = {127, 0, 0,127,127, 0, 0, 0,127, 0, 0, 0,127, 0, 0, 0}; //Bassdrum
int sn2 [] = { 0, 0, 0, 0, 0,127, 0, 0, 0, 0, 0, 0,127, 0,127, 0}; //Snare
int hho2 [] = { 0, 0, 0,127, 0, 0, 0, 0,127, 0, 0, 0, 0, 0,127, 0}; //Hihat Open
int hhc2 [] = {127,127, 0, 0,127, 0,127, 0, 0, 0,127, 0, 0, 0,127,127}; //Hihat Close +14.5, 16
int hhp2 [] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,127, 0, 0}; //Hihat Pedal


// DDT pattern3 "Fanga"
// Tick 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
int hb3 [] = {0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127}; //heartbeat
int bd3 [] = {127, 0, 0, 0,127, 0,127, 0, 0, 0,127, 0, 0, 0, 0, 0}; //Bassdrum
int sn3 [] = { 0, 0, 0, 0,127, 0, 0, 0, 0, 0, 0, 0,127, 0,127, 0}; //Snare
int hho3 [] = {127, 0, 0, 0,127, 0, 0, 0,127, 0, 0, 0,127, 0, 0, 0}; //Hihat Open
int hhc3 [] = {127,110, 0, 0,127,110, 0, 0,127,110, 0, 0,127,110, 0, 0}; //Hihat Close
int hhp3 [] = {127, 0,127, 0, 0, 0, 0, 0,127, 0,127, 0, 0, 0, 0, 0}; //Hihat Pedal


// DDT pattern4 "BossaNova"
// Tick 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
int hb4 [] = {0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127}; //heartbeat
int bd4 [] = {127, 0, 0,100,127, 0, 0,100,127, 0, 0,100,127, 0, 0, 0}; //Bassdrum
int sn4 [] = {127, 0,127, 0, 0,127, 0,127, 0,127, 0,  0,127, 0,127, 0}; //Snare
int hho4 [] = {127, 0, 0, 0, 0,127, 0,127, 0, 0, 0,127, 0,127, 0, 0}; //Hihat Open
int hhc4 [] = { 0, 0,127,110, 0,127,110, 0,127,110, 0, 0,127,110, 0, 0}; //Hihat Close
int hhp4 [] = { 0, 0, 0, 0,110, 0, 0,110, 0, 0,110, 0, 0, 0,127, 0}; //Hihat Pedal


// DDT pattern5 "DubStep"
// Tick 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
int hb5 [] = {0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127}; //heartbeat
int bd5 [] = {127, 0, 0, 0,  0, 0,127, 0, 0, 0, 0, 0,127, 0, 0, 0}; //Bassdrum
int sn5 [] = { 0, 0, 0, 0, 0, 0, 0, 0,127, 0, 0, 0, 0, 0,127, 0}; //Snare
int hho5 [] = { 0, 0, 0, 0, 0, 0, 0,127, 0, 0, 0, 0, 0,127, 0, 0}; //Hihat Open
int hhc5 [] = { 0,127, 0,127, 0, 0, 0, 0, 0,127, 0,127, 0, 0, 0, 0}; //Hihat Close
int hhp5 [] = { 0, 0, 0, 0, 0,127, 0, 0, 0, 0, 0, 0, 0,127, 0, 0}; //Hihat Pedal

// test pattern6
// Tick 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
//int hb6 [] = {127, 0, 0, 0, 0, 0, 0, 127, 0, 0, 0, 0, 0, 0, 0, 127}; //heartbeat
//int bd6 [] = {127, 0, 70, 70,  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 127}; //Bassdrum
//int sn6 [] = {0, 127, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 0}; //Snare
//int hho6 [] = {127, 0, 0, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127}; //Hihat Open
//int hhc6 [] = {0, 127, 127, 127,  127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 0}; //Hihat Close
//int hhp6 [] = {0, 0, 127, 0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; //Hihat Pedal

//Bass CEGBA_DBC_FGEDC

int bassline [] = {12, 16, 19, 23, 21, 0, 26, 23, 24, 0, 17, 19, 16, 14, 12};

//Lead CEGBA_DBC_FGEDC

int leadline [] = {24, 28, 31, 35, 33, 0, 38, 35, 36, 0, 29, 31, 28, 26, 24}; 

//Lead C_EGB_A_C^_FGE_D_ | C_EGB_A_D^_B_GC^__ "jingle"
int leadA1 [] = { 24, 0, 28, 31, 35, 0, 33, 0, 36, 0, 29, 31, 28, 0, 26, 0};
int leadA2 [] = { 24, 0, 28, 31, 35, 0, 33, 0, 38, 0, 35, 0, 31, 36, 0, 0};

//Lead C_C_C_CDE_E_E___ | A_A_AAAGF_F_FGFG "since you've been gone"
int leadB1 [] = { 24, 0, 24, 0, 24, 0, 24, 26, 28, 0, 28, 0, 28, 0, 0, 0};
int leadB2 [] = { 33, 0, 33, 0, 33,  33, 33, 31, 29, 0, 29, 0, 29, 31, 29, 31};  
 
//Lead A__G_G_GF_F_G___ | A__B_B_BC^_G_EFED "finding every breath"
int leadC1 [] = { 33, 0, 0, 31, 0, 31, 0, 31, 29, 0, 29, 0, 31, 0, 0, 0};
int leadC2 [] = { 33, 0, 0, 35, 0, 35, 0, 35, 36, 0, 31, 0, 28, 29, 28, 26};  
  
//Lead GGGF_FG___eb_G__ | _GGGF_Fe___eF_G_ "heartbeat slice"
int leadD1 [] = { 31, 31, 31, 29, 0, 29, 31, 0, 0, 0, 27, 34, 0, 31, 0, 0};
int leadD2 [] = { 0, 31, 31, 31, 29, 0, 29, 27, 0, 0, 0, 27, 29, 0, 31, 0};  
 
//Lead b_GFGbGFe_C^_GFGb | b_GFGC^_CeF_GaGFe "art beet vice"
int leadE1 [] = { 33, 0, 31, 29, 31, 33, 31, 29, 27, 0, 36, 0, 31, 29, 31, 33};
int leadE2 [] = { 33, 0, 31, 29, 31, 36, 0, 24, 27, 29, 0, 31, 32, 31, 29, 27};


//memcpy( bd, bd0,sizeof(bd0));

// * Some basic settings */
int drumChannel = 9;              // MIDI drumChannel number
int channel0 = 0;
int tempo = 120;              // Start tempo
int contactState = 0;
int prevcontactState = 0;
int pulseState = 0;
int prevpulseState = 0;

/*     */
int tickNo = 0;                   // Our tick number variable

String inputString = "";         // a string to hold incoming data

void setup() {
  memcpy( hb[0], hb0,sizeof(hb0));
  memcpy( bd[0], bd0,sizeof(bd0));
  memcpy( sn[0], sn0,sizeof(sn0));
  memcpy( hho[0], hho0,sizeof(hho0));
  memcpy( hhc[0], hhc0,sizeof(hhc0));
  memcpy( hhp[0], hhp0,sizeof(hhp0));
 
  memcpy( hb[1], hb1,sizeof(hb0)); 
  memcpy( bd[1], bd1,sizeof(bd0));
  memcpy( sn[1], sn1,sizeof(sn0));
  memcpy( hho[1], hho1,sizeof(hho0));
  memcpy( hhc[1], hhc1,sizeof(hhc0));
  memcpy( hhp[1], hhp1,sizeof(hhp0));  

  memcpy( hb[2], hb2,sizeof(hb0));
  memcpy( bd[2], bd2,sizeof(bd0));
  memcpy( sn[2], sn2,sizeof(sn0));
  memcpy( hho[2], hho2,sizeof(hho0));
  memcpy( hhc[2], hhc2,sizeof(hhc0));
  memcpy( hhp[2], hhp2,sizeof(hhp0));
  
  memcpy( hb[3], hb3,sizeof(hb0));
  memcpy( bd[3], bd3,sizeof(bd0));
  memcpy( sn[3], sn3,sizeof(sn0));
  memcpy( hho[3], hho3,sizeof(hho0));
  memcpy( hhc[3], hhc3,sizeof(hhc0));
  memcpy( hhp[3], hhp3,sizeof(hhp0)); 

  memcpy( hb[4], hb4,sizeof(hb0));  
  memcpy( bd[4], bd4,sizeof(bd0));
  memcpy( sn[4], sn4,sizeof(sn0));
  memcpy( hho[4], hho4,sizeof(hho0));
  memcpy( hhc[4], hhc4,sizeof(hhc0));
  memcpy( hhp[4], hhp4,sizeof(hhp0));  

  memcpy( hb[5], hb5,sizeof(hb0));   
  memcpy( bd[5], bd5,sizeof(bd0));
  memcpy( sn[5], sn5,sizeof(sn0));
  memcpy( hho[5], hho5,sizeof(hho0));
  memcpy( hhc[5], hhc5,sizeof(hhc0));
  memcpy( hhp[5], hhp5,sizeof(hhp0));  
  
  memcpy( leadpat1[0], leadA1, sizeof(leadA1));
  memcpy( leadpat1[1], leadB1, sizeof(leadA1));
  memcpy( leadpat1[2], leadC1, sizeof(leadA1));
  memcpy( leadpat1[3], leadD1, sizeof(leadA1));
  memcpy( leadpat1[4], leadE1, sizeof(leadA1));
  
  memcpy( leadpat2[0], leadA2, sizeof(leadA1));
  memcpy( leadpat2[1], leadB2, sizeof(leadA1));
  memcpy( leadpat2[2], leadC2, sizeof(leadA1));
  memcpy( leadpat2[3], leadD2, sizeof(leadA1));
  memcpy( leadpat2[4], leadE2, sizeof(leadA1));

//  memcpy( hb[6], hb6,sizeof(hb0));     
//  memcpy( bd[6], bd6,sizeof(bd0));
//  memcpy( sn[6], sn6,sizeof(sn0));
//  memcpy( hho[6], hho6,sizeof(hho0));
//  memcpy( hhc[6], hhc6,sizeof(hhc0));
//  memcpy( hhp[6], hhp6,sizeof(hhp0));  

  Serial1.begin(115200);  //setup serial1 get data from mod-ekg
  Serial.begin(9600);//setup serial to get data over xbee	
  TCL.begin();	

  synth.midiReset();            // Do a complete MIDI reset

  //setReverb( drumChannel , program , level , feedback , delayFeedback )
  // Program 
  // 0: Room1   1: Room2    2: Room3 
  // 3: Hall1   4: Hall2    5: Plate
  // 6: Delay   7: Pan delay
  synth.setReverb(drumChannel,5,255,100); // A Plate Reverb with maximum effect level

  synth.setChannelVolume(drumChannel, 127); // max. drumChannel volume
  
  //synth.setReverb(channel0,5,255,100); // A Plate Reverb with maximum effect level
 // synth.setReverb(channel0,5,255,100); // A Plate Reverb with maximum effect level
  synth.setChannelVolume(channel0, 127); // max. drumChannel volume
  synth.setMasterVolume(255);	// max. master volume
  loadBlank;
  sendLights();

}

void loop() {
  //Serial.println("test");

  // start code to determine contact state
  contactState = digitalRead(22);
  if( (prevcontactState == 0) && (contactState==1) ){ //if contact started
        contStartTime = millis(); //get time at start of contact
        prevcontactState = 1;  
        //recordFlag = 1;
        prerecordFlag = 1;        
  } 
  
  if( (contactState ==1 ) && (millis() > (contStartTime + 2000))&& (prerecordFlag == 1) ){// if .5 second has passed since beginning of contact{
    recordFlag = 1;
    prerecordFlag = 0;
  }
  

  
  if((prevcontactState == 1) && (contactState==0)){ 
    //if contact ends reset everything      
        prevcontactState = 0; 
        recordFlag = 0;
        prerecordFlag = 0;
        pTimeIx = -1;
        pTimeClear();
        halfSecondCount = 0;
        barCount = 1;
        tickNo = 0;
        musicStart = 0;
        fadeCount = 0;
        fadeDir = 1;
        loadBlank();
        sendLights();
        samples.clear();
  }
  // end code to determine contact state
  
  //check if pulse happened
  pulseState = digitalRead(23);
  if ( (prevpulseState != pulseState) && (recordFlag == 1) ){//if pulse indicator has transitioned
    prevpulseState = pulseState;
    handlePulse();
  }
  
  if ( (millis()-contStartTime)/6000 >= 1 ){
    recordFlag = 0;

  }
  
  if( contactState == 1 && recordFlag == 0 && musicStart == 0 && prerecordFlag == 0){
    musicStart = 1;
    patternNo++;
    if(patternNo == 6)
      patternNo = 0;
    lockedBPM = samples.getMedian();
    //Serial.println("test");
    if( (50 < lockedBPM) && (lockedBPM < 120 )){
      interval = 15000/lockedBPM;
      Serial.write(lockedBPM);
    }
    else{
      int randBPM = random(70,90);
      interval = 15000/randBPM;
      lockedBPM = randBPM;
    }
    
    leadno = random(0,4);
    
    int instrsel = lockedBPM%3;
    if(instrsel == 0)
      instr = 33;
      else if(instrsel ==1 )
      instr = 36;
      else
      instr = 38;
    
    loadBlank();
    sendLights();
  }
  
  if( contactState == 1 && recordFlag == 1){
    if( (musicStart==0) && ((millis() - contStartTime)/750  > halfSecondCount) ){  // if another half second has occured
    halfSecondCount++;
    loadScale(halfSecondCount);
    sendLights();
    }
  }
  
  //for debugging
//  musicStart =1;
//  patternNo = 1;
//  interval = 16000/73;
  //barCount = 1;
//musicStart = 1;

//guitar 27
  if( musicStart == 1 ){ //still has contact and done recording
       
       unsigned long currentMillis = millis();
       
       if(currentMillis - previousMillis > interval) {
          previousMillis = currentMillis;   
  
          if( (barCount <= 2) || (barCount>=13))
            bassDrm(hb[patternNo][tickNo]);
          //bassDrm(127);
          //leadVoiceOn( leadline[tickNo]);
          //leadVoiceOff( leadline[tickNo-2]);
          //synthbassVoice( bassline[tickNo]);
          
          //synthbass( 2*bassline[tickNo]);
          //synthbass(127);
          if((tickNo+1)%4==0){
            loadRed();
            sendLights();
          }
          if((tickNo-1)%4==0){
            loadBlank();
            sendLights();
          }
//int instr = ;
//leadno = 2;
//33 pick bass
//36 slap bass
//38 synth bass 1

//          if( barCount %2 ==0 ){
//              leadVoiceOn( leadpat1[leadno][tickNo],instr);
//              leadVoiceOff( leadpat1[leadno][tickNo-2],instr);
//          }
//          else{
//              leadVoiceOn( leadpat2[leadno][tickNo],instr);
//              leadVoiceOff( leadpat2[leadno][tickNo-2],instr);            
//          }
         
          if( (barCount > 2)&&  (barCount <= 12) ){
            bassDrm(bd[patternNo][tickNo]);
            snareDrm(sn[patternNo][tickNo]);
          }
          if( (barCount > 3)&&(barCount <= 11)  ){
            hihatClose(hhc[patternNo][tickNo]);
            hihatOpen(hho[patternNo][tickNo]);
            hihatPedal(hhp[patternNo][tickNo]);
          }
          if( (barCount ==6) || (barCount == 8) ){
          leadVoiceOn( leadpat1[leadno][tickNo], instr);
          leadVoiceOff( leadpat1[leadno][tickNo-2], instr);
          }
          if( (barCount == 7) || (barCount == 9) ){
          leadVoiceOn( leadpat2[leadno][tickNo],instr);
          leadVoiceOff( leadpat2[leadno][tickNo-2],instr);
          }
          
            tickNo++;
            
            if( tickNo == 16 ){
              tickNo = 0;
              barCount++;
            }
            if( barCount == 13 )
              barCount = 1;        
       }
    
    
  }
  
  if( contactState == 0 && recordFlag!=1){ //if no contact go through slow fade
    unsigned long currentMillisFade = millis();
    
     if(currentMillisFade - previousMillisFade > fadeInterval) {
          previousMillisFade = currentMillisFade;  
          
          if(fadeDir == 1 )//if forward
            fadeCount++;
          else
            fadeCount--;
            
          if( fadeCount == 50 && fadeDir==1){
            fadeDir = 0;
          }
          
          if( fadeCount == 0 && fadeDir ==0){
            fadeDir = 1;  
          }
         loadWhiteFade( fadeCount );
         sendLights();
     } 
  }
  
} 

// Maybe it looks a bit overdone to send both velocity 0 note On and note Off information
// It saves some memory NOT to check for double note Off information...ah well..

void bassDrm (int vel )
{
 synth.noteOn(drumChannel, bass, vel);      // play a note
 synth.noteOff(drumChannel, bass);         // send note off
}

void snareDrm (int vel)
{
 synth.noteOn(drumChannel, snare, vel);	// play a note
 synth.noteOff(drumChannel, snare);         // send note off

}

void hihatClose (int vel )
{
 synth.noteOn(drumChannel, hihatC, vel);	// play a note
 synth.noteOff(drumChannel, hihatC);        // send note off 
}

void hihatPedal (int vel)
{
 synth.noteOn(drumChannel, hihatP, vel);	// play a note
 synth.noteOff(drumChannel, hihatP);        // send note off   
}

void hihatOpen (int vel )
{
 synth.noteOn(drumChannel, hihatO, vel);	// play a note
 synth.noteOff(drumChannel, hihatO);        // send note off 
}


void synthbassVoice (int note )

{
 synth.programChange(0, 0, synthbass);
 synth.noteOn(channel0, 20+note, 127); // play a note

 synth.noteOff(channel0, note); // send note off

}

//void lead (int vel )
//
//{ 
//synth.noteOn(drumChannel, bass, vel); // play a note
//
//synth.noteOff(drumChannel, bass); // send note off
//
//}

void leadVoiceOn (int note ,int instr)
{
   synth.programChange(0, 0, instr);
   synth.noteOn(channel0, note, 127);      // play a note
   //delay(300);
   //synth.noteOff(channel0, note);         // send note off
}

void leadVoiceOff (int note ,int instr)
{
   synth.programChange(0, 0, instr);
   //synth.noteOn(channel0, note, 127);      // play a note
   //delay(300);
   synth.noteOff(channel0, note);         // send note off
}

//void tick ()
//{
// delay(tempo);
//}
/*
void serialEvent1() {
  while (Serial1.available()) {
    // get the new byte:
    char inChar = (char)Serial1.read();
   Serial.write(inChar); 
    if ( (inChar == 'p') && (recordFlag == 1) ) {  //when 'p' sent over serial from mod-ekg
      pTimeCur = millis();
      pTimeDiff = pTimeCur - pTimePrev;
      pTimePrev = pTimeCur;
      int BPM = 60000/pTimeDiff;

      
      if( pTimeIx != -1 ) {           
        pTime[pTimeIx] = ( pTimeDiff ); 
        if( 50 < BPM < 130 ){
          Serial.write(BPM);      
          samples.add(BPM);
        }
      }
      pTimeIx++; 
      }      
    } 
}
*/

void handlePulse(){
      pTimeCur = millis();
      pTimeDiff = pTimeCur - pTimePrev;
      pTimePrev = pTimeCur;
      int BPM = 60000/pTimeDiff;

      
      if( pTimeIx != -1 ) {           
        pTime[pTimeIx] = ( pTimeDiff ); 
        if( 50 < BPM < 130 ){
          //Serial.write(BPM);      
          samples.add(BPM);
        }
      }
      pTimeIx++; 
}

void sendLights(){
  
    TCL.sendEmptyFrame();
        for(int i=0;i<LEDS;i++) {
          TCL.sendColor( red[i],green[i],blue[i]);
      }
    TCL.sendEmptyFrame();
    
}

void loadBlank(){
      for(int i=0;i<LEDS;i++) {
        red[i] = 0;
        blue[i] = 0;
        green[i] = 0;
      }
}

void loadRed(){
      for(int i=0;i<LEDS;i++) {
        red[i] = 255;
        blue[i] = 0;
        green[i] = 0;
      }
}

void loadWhite(){
      for(int i=0;i<LEDS;i++) {
        red[i] = 255;
        blue[i] = 255;
        green[i] = 255;
      }
}

void loadScale( int num ){
  loadBlank();
  for( int i = 0; i < num; i++)
    red[i] = 255;

  for( int i = (LEDS-1); i> (LEDS - (num+1)); i--)
    red[i] = 255;
}

void pTimeClear(){
  for(int i = 0; i<30; i++)
    pTime[i] = 0;
}

void loadWhiteFade( int val ){
        for(int i=0;i<LEDS;i++) {
        red[i] = val;
        blue[i] = val;
        green[i] = val;
      }
}
