
skipc	macro
	btfss	STATUS,C
	endm
skipb	macro
	btfsc	STATUS,C
	endm
skipz	macro
	btfss	STATUS,Z
	endm
skipnc	macro
	btfsc	STATUS,C
	endm
skipnb	macro
	btfss	STATUS,C
	endm
skipnz	macro
	btfsc	STATUS,Z
	endm

skip_eq	macro	REGNUM, VALUE
	movlw	VALUE
	subwf	REGNUM,w		;W=REGNUM-VALUE
	skipz				;Skip if REGNUM==VALUE
	endm

skip_ne	macro	REGNUM, VALUE
	movlw	VALUE
	subwf	REGNUM,w		;W=REGNUM-VALUE
	skipnz				;Skip if REGNUM!=VALUE
	endm

skip_lt	macro	REGNUM, VALUE
	movlw	VALUE
	subwf	REGNUM,w		;W=REGNUM-VALUE
	skipb				;Skip if REGNUM<VALUE
	endm

skip_ge MACRO	REGNUM, VALUE
	movlw	VALUE
	subwf	REGNUM,w		;w=REGNUM-VALUE
	skipnb				;Skip next if REGNUM>=VALUE
	endm

jumpz	MACRO	DEST
	skipnz
	goto	DEST
	endm

jumpnz	MACRO	DEST
	skipz
	goto	DEST
	endm


copyreg	macro	SRCREG, DESTREG
	movf	SRCREG,w		;Set DESTREG=SRCREG
	movwf	DESTREG
	endm

min	macro CURRENT, MIN		;Ensure register >= literal value 'MIN'
	movlw	MIN
	subwf	CURRENT,w		;w = CURRENT-MIN.  if current<MIN, borrow occurs. Carry=0
	movlw	MIN
	skipnb				;skip next if current>=MIN
	movwf	CURRENT 
	endm

max	macro CURRENT, MAX		;Ensure register <= literal value 'MAX'
	movlw	MAX
	subwf	CURRENT,w		;w = CURRENT-MAX,  if current>MAX, no borrow occurs.
	movlw	MAX
	skipb				;Skip next if current<=MAX
	movwf	CURRENT 
	endm

delay	MACRO	COUNT			;Wait for (4*COUNT) instructions. ie:
	local	_loop			;  COUNT=1:  delay=4
	movlw	COUNT			;  COUNT=2:  delay=8
_loop:	movwf	_delay			;  COUNT=3:  delay=12
	decfsz	_delay,w		;  COUNT=4;  delay=16
	goto	_loop			;  etc...
	endm


;;
;; Set a register.  
;; If register in non-zero bank, perform setup.
;; If REGNUM negative, don't cleanup bank select afterwards.
;;
setreg	macro	REGNUM, VALUE
	errorlevel -302
	if (REGNUM) >= 0
	 if (REGNUM) > 0x7F
	  banksel REGNUM
	 endif
	 if (VALUE) == 0
	  clrf	REGNUM
	 else
 	  movlw	VALUE
	  movwf	REGNUM
	 endif
	 if (REGNUM) > 0x7F
	  movlb	0
	 endif
	else
	 if (-REGNUM) > 0x7F
	  banksel -REGNUM
	 endif
	 if (VALUE) == 0
	  clrf	-REGNUM
	 else
 	  movlw	VALUE
	  movwf	-REGNUM
	 endif
	endif
	errorlevel +302
	endm


;;
;; Filtering/Averaging operations...
;;
avg2	macro	SAMPLE,AVERAGE ;; AVERAGE = (AVERAGE+SAMPLE)/2
	movf	SAMPLE,w
	addwf	AVERAGE,f
	rrf	AVERAGE,f
	endm

avg14	macro SAMPLE,AVERAGE,TEMP ;; AVERAGE = (3*AVERAGE + SAMPLE)/4
	clrf	TEMP
	rlf	AVERAGE,w ; w=AVERAGE*2
	rlf	TEMP,f	  ; TEMP holds carry
	addwf	SAMPLE,w  ; w=AVERAGE*2 + SAMPLE
	skipnc
	incf	TEMP,f	  ; update carry count
	addwf	AVERAGE,f ; AVERAGE = AVERAGE*3 + SAMPLE
	skipnc
	incf	TEMP,f	  ; update carry count
	rrf	TEMP,f	  ; divide by 4
	rrf	AVERAGE,f
	rrf	TEMP,f
	rrf	AVERAGE,f
	endm

avg34	macro SAMPLE,AVERAGE,TEMP ;; AVERAGE = (AVERAGE * 3*SAMPLE)/4
	clrf	TEMP
	rlf	SAMPLE,w  ; w=SAMPLE*2
	rlf	TEMP,f	  ; TEMP holds carry
	addwf	SAMPLE,w  ; w=SAMPLE*3
	skipnc
	incf	TEMP,f	  ; update carry count
	addwf	AVERAGE,f ; AVERAGE = AVERAGE + SAMPLE*3
	skipnc
	incf	TEMP,f	  ; update carry count
	rrf	TEMP,f    ; divide by 4
	rrf	AVERAGE,f
	rrf	TEMP,f
	rrf	AVERAGE,f
	endm


;;
;; 16-bit operations...
;;
clr16	macro 	REG16			;REG16=0
	clrf	REG16
	clrf	REG16+1
	endm

set16	macro	REG16,VALUE
	movlw	(VALUE) & 0xFF
	movwf	REG16
	movlw	((VALUE)>>8) & 0xFF
	movwf	(REG16+1)
	endm

copy16	macro	SRCREG,DESTREG		;DESTREG = SRCREG
	copyreg	(SRCREG),(DESTREG)
	copyreg	(SRCREG+1),(DESTREG+1)
	endm

add16	macro	SRCREG,DESTREG		;DESTREG += SRCREG
	movf	(SRCREG),w
	addwf	(DESTREG),f
	movf	(SRCREG+1),w
	addwfc	(DESTREG+1),f
	endm

shl16	macro	REG16			;REG16<<=1
	clrc
	rlf	REG16
	rlf	(REG16+1)
	endm

shr16	macro	REG16			;REG16>>=1
	clrc
	rrf	(REG16+1)
	rrf	REG16
	endm

test16	macro	REG16			;Set Z if REG16 zero
	movf	REG16,w	
	iorwf	(REG16+1),w
	endm


;;
;; 8x8 multiplier.  16-bit result.  Contents of W register multipled by LSB of PRODUCT. 
;;   mult8x8slow (smallest): 10 instr, 60 cycles, needs temp register
;;   mult8x8fast (fastest):  34 instr, 34 cycles
;;   From http://www.piclist.com/techref/microchip/math/mul/index.htm
;;
mstep8x8 macro PRODUCT
	skipnc
	addwf	(PRODUCT+1),f
	rrf	(PRODUCT+1),f
	rrf	(PRODUCT),f
	endm

mult8x8slow macro PRODUCT, TEMP
	local	mloop
	clrf	(TEMP)			;set TEMP=8 without using w register
	bsf	(TEMP),3
	clrf	(PRODUCT+1)
	rrf	(PRODUCT),f
mloop:	mstep8x8 PRODUCT
	decfsz	(TEMP)
	goto	mloop
	endm

mult8x8fast macro PRODUCT
	clrf	(PRODUCT+1)
	rrf	(PRODUCT),f
	mstep8x8 PRODUCT
	mstep8x8 PRODUCT
	mstep8x8 PRODUCT
	mstep8x8 PRODUCT
	mstep8x8 PRODUCT
	mstep8x8 PRODUCT
	mstep8x8 PRODUCT
	mstep8x8 PRODUCT
	endm


;;
;; 16x8 multiplier.  24-bit result.  Contents of W register multipled by PARAM16. 
;;   mult16x8slow (smallest):  19 instr.  125 cycles (worstcase).  105 cycles (average).
;;   mult16x8fast (fastest):   69 instr.  69 cycles.
;;   From http://www.piclist.com/techref/microchip/math/mul/index.htm
;;
mult16x8slow macro PARAM16, PARAM8, PRODUCT
        local   m1, m2
        clrf    (PRODUCT+2)
        clrf    (PRODUCT+1)
        clrf    (PRODUCT)
        movwf   PARAM8 	
        bsf     (PRODUCT),7
m1:     rrf     PARAM8,F
        skipc
        goto    m2
        movfw   (PARAM16)
        addwf   (PRODUCT+1),F
        movfw   (PARAM16+1)
        skipnc
        incfsz  (PARAM16+1),W
        addwf   (PRODUCT+2),F
m2:     rrf     (PRODUCT+2),F
        rrf     (PRODUCT+1),F
        rrf     (PRODUCT),F
        skipc
        goto    m1
        endm

mstepR16x8 macro A,BIT,P2,P1
	btfsc	A,BIT
	addwf	P2,f
	rrf	P2,f
	rrf	P1,f
	endm

;; Multiply 16-bit register by 8-bit register.  24-bit result...
multR16xR8fast macro PARAM16, PARAM8, PRODUCT0, PRODUCT1, PRODUCT2 ; p16,p8,lsb,mid,msb
	clrf	(PRODUCT)
	clrf	(PRODUCT2)
	clrc
	movfw	PARAM8
	mstepR16x8 (PARAM16),0,(PRODUCT2),(PRODUCT0)
	mstepR16x8 (PARAM16),1,(PRODUCT2),(PRODUCT0)
	mstepR16x8 (PARAM16),2,(PRODUCT2),(PRODUCT0)
	mstepR16x8 (PARAM16),3,(PRODUCT2),(PRODUCT0)
	mstepR16x8 (PARAM16),4,(PRODUCT2),(PRODUCT0)
	mstepR16x8 (PARAM16),5,(PRODUCT2),(PRODUCT0)
	mstepR16x8 (PARAM16),6,(PRODUCT2),(PRODUCT0)
	mstepR16x8 (PARAM16),7,(PRODUCT2),(PRODUCT0)
	clrf	(PRODUCT1)
	mstepR16x8 (PARAM16+1),0,(PRODUCT2),(PRODUCT1)
	mstepR16x8 (PARAM16+1),1,(PRODUCT2),(PRODUCT1)
	mstepR16x8 (PARAM16+1),2,(PRODUCT2),(PRODUCT1)
	mstepR16x8 (PARAM16+1),3,(PRODUCT2),(PRODUCT1)
	mstepR16x8 (PARAM16+1),4,(PRODUCT2),(PRODUCT1)
	mstepR16x8 (PARAM16+1),5,(PRODUCT2),(PRODUCT1)
	mstepR16x8 (PARAM16+1),6,(PRODUCT2),(PRODUCT1)
	mstepR16x8 (PARAM16+1),7,(PRODUCT2),(PRODUCT1)
	endm

mstepC16x8 macro CONST,MASK,P2,P1
	if ((CONST) & MASK)>0
	 addwf	P2,f
	endif
	rrf	P2,f
	rrf	P1,f
	endm

;; Multiply 16-bit constant by W register.  24-bit result...
multC16xW macro CONST16, PRODUCT0, PRODUCT1, PRODUCT2 ; p16,p8,lsb,mid,msb
	clrf	(PRODUCT0)
	clrf	(PRODUCT2)
	clrc
	mstepC16x8 (CONST16),0x0001,(PRODUCT2),(PRODUCT0)
	mstepC16x8 (CONST16),0x0002,(PRODUCT2),(PRODUCT0)
	mstepC16x8 (CONST16),0x0004,(PRODUCT2),(PRODUCT0)
	mstepC16x8 (CONST16),0x0008,(PRODUCT2),(PRODUCT0)
	mstepC16x8 (CONST16),0x0010,(PRODUCT2),(PRODUCT0)
	mstepC16x8 (CONST16),0x0020,(PRODUCT2),(PRODUCT0)
	mstepC16x8 (CONST16),0x0040,(PRODUCT2),(PRODUCT0)
	mstepC16x8 (CONST16),0x0080,(PRODUCT2),(PRODUCT0)
	clrf	(PRODUCT1)
	mstepC16x8 (CONST16),0x0100,(PRODUCT2),(PRODUCT1)
	mstepC16x8 (CONST16),0x0200,(PRODUCT2),(PRODUCT1)
	mstepC16x8 (CONST16),0x0400,(PRODUCT2),(PRODUCT1)
	mstepC16x8 (CONST16),0x0800,(PRODUCT2),(PRODUCT1)
	mstepC16x8 (CONST16),0x1000,(PRODUCT2),(PRODUCT1)
	mstepC16x8 (CONST16),0x2000,(PRODUCT2),(PRODUCT1)
	mstepC16x8 (CONST16),0x4000,(PRODUCT2),(PRODUCT1)
	mstepC16x8 (CONST16),0x8000,(PRODUCT2),(PRODUCT1)
	endm




