#include <avr/io.h>
#include <util/delay.h>
#define F_CPU 800000UL

float t_25, t_16, t_9, t_4, t_1;	// float type is unnecessary but I have plenty of memory

int main(void)
{
	//pre-set for 1V domain @ 5mV/s rate.   Change if your experiment is different.
	t_25 = 207*207000/(2.1920*227);		// 207000 is the experiment length in milliseconds
	t_16 = 207*207000/(1.5580*227);		// 207/227 is a calibration constant
	t_9 = 207*304000/(1.2585*227);		// 2.1920, 1.5580, etc are the lengths of the for loops corresponding to that part of the experiment
	t_4 = 207*304000/(1.1000*227);
	t_1 = 207*304000/(1.0220*227);
	
	// set output pin
	DDRB |= (1 << DDB0) | (1 << DDB1);
	// fast PWM mode, wave form generation bit [1:0]
	TCCR0A = (1 << COM0A1) | (1 << WGM00) | (1 << WGM01);
	// waveform bits [2], prescalar 1024
	TCCR0B = (1 << WGM02) | (1 << CS02) | (1 << CS00);
	// output compare register
	OCR0A = 0;
	
	for(float t=0; t<t_25; t++)	
	{
		PORTB |= (1 << PB1);
		_delay_ms(1.192);			// this defines the duty cycle and thus the analog voltage output
		PORTB &= ~(1 << PB1);		// a larger value gives a larger duty cycle and thus higher voltage
		_delay_ms(1);				// the 1 ms (off) delay is chosen arbitrarily
	}

	for(float t=0; t<t_16; t++)
	{
		PORTB |= (1 << PB1);
		_delay_ms(0.558);
		PORTB &= ~(1 << PB1);
		_delay_ms(1);
	}
	
	for(float t=0; t<t_9; t++)
	{
		PORTB |= (1 << PB1);
		_delay_ms((0.2585));
		PORTB &= ~(1 << PB1);
		_delay_ms(1);
	}

	for(float t=0; t<t_4; t++)
	{
		PORTB |= (1 << PB1);
		_delay_ms(0.1);
		PORTB &= ~(1 << PB1);
		_delay_ms(1);
	}

	for(float t=0; t<t_1; t++)
	{
		PORTB |= (1 << PB1);
		_delay_ms(0.022);
		PORTB &= ~(1 << PB1);
		_delay_ms(1);
	}
	
	while(1) // end state
	{
		PORTB |= (1 << PB1);
		_delay_ms(0);
		PORTB &= ~(1 << PB1);
		_delay_ms(600000);	// 10 mins to avoid noise on the line 
	} 
}