#include <Wire.h>
#include <Time.h>
#include <DS1307RTC.h>
#include <AccelStepper.h>

/*
Created by NespLab, 5/2015 -> nesplab@gmail.com
+  RTC
+  SCL -> A5
+  SDA -> A4
+
+  EasyDriver
+  dir    -> 3
+  step   -> 2
+  enable -> 4
*/

#define set_time_pin      13

#define REFRESH_RATE      60      //how much time between a rotation and the other?
#define cicles            REFRESH_RATE / 30
#define remain            REFRESH_RATE % 30

#define use_enable_pin          //comment if you want to keep the stepper always enabled

#define STEPS_PER_SECOND  1.92
#define max_speed         1100

#ifdef use_enable_pin
  #define enable_pin      4    //pin to which you connected the enable from the EasyDriver
#endif

#define DIRECTION         1  // 1 <-> -1    set to make your motor spin in the correct direction


AccelStepper stepper(AccelStepper::DRIVER);
tmElements_t tm;
byte precedent;
long diff = 0;
float rest = 0;


void setup(){ 
  
  Serial.begin(9600);
  Serial.print("steps: ");
  Serial.println(STEPS_PER_SECOND);
  
  #ifdef use_enable_pin
    pinMode(enable_pin, OUTPUT);
    digitalWrite(enable_pin, 1);
  #endif
  
  stepper.setCurrentPosition(0);
  stepper.setMaxSpeed(max_speed);
  stepper.setAcceleration(max_speed);
  
  #ifdef FIRST_RUN
    first_run();
  #endif
  
  #ifdef set_time_pin
    pinMode(set_time_pin, INPUT);
    delay(10);
    if(digitalRead(set_time_pin) == 0){
      long pos = set_current_time(0);
      do{
        delay(1000);
        RTC.read(tm);
      }while(tm.Second > 50);
      set_current_time(pos);
    }
  #endif
  
  RTC.read(tm);
  precedent = tm.Second;
}


void loop(){
   delay(remain*1000);
   for(byte i = 0; i < cicles; i++)
     delay(30000);
   RTC.read(tm);
   Serial.print("dio: ");
   Serial.println(tm.Second);
   Serial.print("rincoglionito: ");
   Serial.println(precedent);
   if(cicles >= 2)
       diff = cicles*30 + tm.Second - precedent;
   else if(tm.Second < precedent)
       diff = 60 + tm.Second - precedent;
   else
     diff = tm.Second - precedent;
   Serial.print("Dio cane: ");
   Serial.println(diff);
   move_n_seconds(diff);
   precedent = tm.Second;
}

#ifdef use_enable_pin

  void move_n_seconds(long seconds){
    digitalWrite(enable_pin, 0);
    delay(100);
    
    double steps_int = DIRECTION * seconds * STEPS_PER_SECOND + rest;
    rest = modf(steps_int, &steps_int);
    stepper.move(steps_int);
    
    while(stepper.distanceToGo() != 0)
      stepper.run();
      
    delay(100);
    digitalWrite(enable_pin, 1);
  }
  
#else

  void move_n_seconds(long seconds){
    double steps_int = DIRECTION * seconds * STEPS_PER_SECOND + rest;
    rest = modf(steps_int, &steps_int);
    stepper.move(steps_int);
    
    while(stepper.distanceToGo() != 0)
      stepper.run();
  }
  
#endif

#ifdef set_time_pin

long set_current_time(long pos){
  RTC.read(tm);
  
  if(pos == 0){
    int h = tm.Hour;
    for(int i = 0; i < h; i++)
      move_n_seconds(3600);
  }
  
  long m = 60*tm.Minute;
  diff = m - pos;
  move_n_seconds(diff);
  
  return m;
}

void move_to_hour(int h){
  
}


#endif
