<?php

   // this script is called every minute by a cron job.
   // it talks to the esp8266 and the temperature/humidity sensor by sending a cURL request.
   // the values it gets back from the esp8266 are stored in a sqlite database.

 
   error_reporting(E_ALL);
   ini_set("display_errors", 1);

   // create curl resource
   $curl = curl_init();
   curl_setopt_array($curl, array(
      CURLOPT_RETURNTRANSFER => 1, //return the transfer as a string
      CURLOPT_URL => 'http://xxx.xxx.xxx.xxx:8011/status'
   ));

   $vars = curl_exec($curl);

   if(curl_error($curl)){
       die('Error: "' . curl_error($curl) . '" - Code: ' . curl_errno($curl));
   }

   $vars = explode("|", $vars);
   $temp = htmlspecialchars($vars[0]);
   $hum = htmlspecialchars($vars[1]);
   $heater = htmlspecialchars($vars[2]);
   $goaltemp = htmlspecialchars($vars[3]);

   curl_close($curl);

   // when there are no values, don't do anything
   if ( ! $temp && ! $vars[1] ) {
      exit;
   }


   class MyDB extends SQLite3
   {
      function __construct()
      {
         $this->open('/var/www/html/thermostaat/thermostaat.db');
      }
   }
   $db = new MyDB();
   if(!$db){
      echo $db->lastErrorMsg();
   } else {
      echo "Opened database successfully\n";
   }

   $sql = "INSERT INTO temperatuur (luchtvochtigheid, temperatuur, heater, goaltemp) VALUES ($hum, $temp, $heater, $goaltemp)";

   $ret = $db->exec($sql);
   if(!$ret){
      echo $db->lastErrorMsg();
   } else {
      echo "Records created successfully\n";
   }

   $db->close();

?>