#ifndef SOLDERDOODLE_CONST_H
#define SOLDERDOODLE_CONST_H

#include <stdint.h>

//
//  DEV
//

// For ATtiny: DEV_ARDUINO must be (false)
#define DEV_ARDUINO              (false)

// Debug stuff, print on Serial monitor
#define DEV_PRINT_TOUCH          (false)
#define DEV_PRINT_TOUCH_MIN_MAX  (false)
#define DEV_PRINT_GESTURE_RECOG  (false)
#define DEV_PRINT_FPS            (false)
#define DEV_PRINT_VOLTAGE        (false)
#define DEV_PRINT_IDLE_MILLIS    (false)
#define SERIAL_BAUD_RATE         (57600)

// Dev: Visual tests
#define DEV_TAP_TEST             (false)

// Testing with WS2812 ("NeoPixel") strip
#define DEV_WS2812               (false)

//
//  HEAT MODE
//

// Enable one mode for controlling heat.
// ** BEWARE ** if zero or two+ modes are enabled,
// you are in undefined territory!

// HEAT_ALL_THE_TIME: The tip is always heated,
// based on the selected heat level.
#define HEAT_ALL_THE_TIME             (false)

// HEAT_ON_FIRM_TOUCH: The user must apply constant
// firm pressure to heat the tip.
#define HEAT_ON_FIRM_TOUCH            (true)

// FIXME: HEAT_PRESS_AND_HOLD_TO_LOCK is not supported yet.
#define HEAT_PRESS_AND_HOLD_TO_LOCK   (false)
#define TAPS_TO_RELEASE_LOCK          (2)

//
//  BEHAVIOR and APPEARANCE
//

// LED_BRIGHTNESS: Valid range is [0..31]
#define LED_BRIGHTNESS           (1)
#define LED_COUNT                (7)

// Behavior

#define TAPS_TO_WAKE             (3)
#define TAPS_TO_SLEEP            (3)
#define MAX_TAPS                 (3)

#define CURSOR_DRAG_SPEED_MULT   (3)
#define IDLE_TIMEOUT_SECONDS     ((uint32_t)(5 * 60))
#define IDLE_TIMEOUT_MILLIS      ((uint32_t)(IDLE_TIMEOUT_SECONDS) * 1000)

//
//  TOUCH
//

// TAP threhold value must be less than DRAG.
// Touch sensors attached to the SolderDoodle body
// require more pressure than when the sensor is
// floating in the air.
#define PRESS_THRESHOLD_TAP          (DEV_ARDUINO ? 50 : 650)
#define PRESS_THRESHOLD_DRAG         (DEV_ARDUINO ? 150 : 650)

// Tap vs drag: Don't track Y position below
// a certain threshold. This helps a hardware issue:
// low(er) values appear when touch pressure is light.
//#define TRACK_MIN_MAX_ABOVE_PRESSURE (PRESS_THRESHOLD_DRAG)

// The first 50ms or so: Discard weird "motion"
// generated by the resistive touch sensor.
#define DISCARD_MOVEMENT_FIRST_MILLIS  (90)

// Drags longer than this distance are definitely
// considered drag gestures (not taps):
#define GESTURE_DRAG_DISTANCE        (100)

// Long touches with little/no movement:
// These are definitely taps.
#define TAP_RECOGNITION_MILLIS       ((uint32_t)(250))

// Drag pressure: Reject jittery changes in dy
#define DRAG_JITTER_THRESHOLD        (30)

// Tap times for off|active phases (in milliseconds)
#define TAP_TIME_MIN                 (60)
#define TAP_TIME_MAX                 (500)

// Heat: Press-and-hold values, to latch & release.
#define HEAT_PRESS_LATCH_ON          (PRESS_THRESHOLD_DRAG)
#define HEAT_PRESS_LATCH_OFF         (PRESS_THRESHOLD_TAP)

//
//  MATH
//

#define lerp(a,b,p)   ((a) + ((b) - (a)) * (p))

#define APA102_COLOR_HEADER      (0b11100000 | LED_BRIGHTNESS)

//
//  PINS: Arduino development
//

#if DEV_ARDUINO

// Arduino Uno

const uint8_t HEAT_ENABLE = 13;	// blink pin

const uint8_t LED_DATA = 2;
const uint8_t LED_CLOCK = 3;	// NeoPixel: Not used

const uint8_t BATTERY_VOLTAGE = A0;

// Force-touch resistive sensor
const uint8_t TOUCH_SL = A2;	// sense line, FSLP pin 1
const uint8_t TOUCH_D1 = A3;	// drive line 1, FSLP pin 2
const uint8_t TOUCH_D2 = A4;	// drive line 2, FSLP pin 3
const uint8_t TOUCH_RO = A5;	// sense line with 4.6k resistor

//
//  PINS: ATtiny
//

#else

// ATTiny84 pin definitions

// Physical pin number -> PCINT
// PIN_1 == VCC
//#define ATTINY_PIN_2      (8)	// Wrong!
#define ATTINY_PIN_2      (10)
#define ATTINY_PIN_3      (9)
//#define ATTINY_PIN_4      (11)	// RESET pin. Don't use!
//#define ATTINY_PIN_5      (10)	// Wrong!
#define ATTINY_PIN_5      (8)
#define ATTINY_PIN_6      (7)
#define ATTINY_PIN_7      (6)
#define ATTINY_PIN_8      (5)
#define ATTINY_PIN_9      (4)
#define ATTINY_PIN_10     (3)
#define ATTINY_PIN_11     (2)
#define ATTINY_PIN_12     (1)
#define ATTINY_PIN_13     (0)
// PIN_14 == GND


const uint8_t HEAT_ENABLE = ATTINY_PIN_5;

const uint8_t LED_CLOCK = ATTINY_PIN_2;
const uint8_t LED_DATA = ATTINY_PIN_3;

const uint8_t BATTERY_VOLTAGE = ATTINY_PIN_9;

// Force-touch resistive sensor
const uint8_t TOUCH_RO = ATTINY_PIN_10;
const uint8_t TOUCH_D1 = ATTINY_PIN_11;
const uint8_t TOUCH_D2 = ATTINY_PIN_12;
const uint8_t TOUCH_SL = ATTINY_PIN_13;

#endif



#endif
