const int DATA = 4;
const int CLOCK = 5;
const int LED_COUNT = 7;

int color = 0x1;
int pos = 0;

// the setup routine runs once when you press reset:
void setup() {
  // initialize the digital pin as an output.
  pinMode(DATA, OUTPUT);
	pinMode(CLOCK, OUTPUT);
}

// the loop routine runs over and over again forever:
void loop() {
	// Start frame
	for (byte i = 0; i < 4; i++) {
		shiftOut(DATA, CLOCK, MSBFIRST, 0x0);
	}

	// Color
	for (byte led = 0; led < LED_COUNT; led++) {
		// First byte is: header and global brightness
		shiftOut(DATA, CLOCK, MSBFIRST, 0xff);

		const byte BRIGHT = 0xFF;

		// Blue
		byte blue = ((color & 0x4) && (led <= pos)) ? BRIGHT : 0x0;
		shiftOut(DATA, CLOCK, MSBFIRST, blue);

		// Green
		byte green = ((color & 0x2) && (led <= pos)) ? BRIGHT : 0x0;
		shiftOut(DATA, CLOCK, MSBFIRST, green);

		// Red
		byte red = ((color & 0x1) && (led <= pos)) ? BRIGHT : 0x0;
		shiftOut(DATA, CLOCK, MSBFIRST, red);
	}

	// End frame
	for (byte i = 0; i < 4; i++) {
		shiftOut(DATA, CLOCK, MSBFIRST, 0xff);
	}

	pos++;
	if (pos >= LED_COUNT) {
		pos = 0;
		color++;
		if (color == 0x80) {
			color = 0x1;
		}
	}

	delay(1000);
}
