//the code is based on "the buttons to USB keyboard example" from teensy
//I modified the code for use with my USB footpedal keyboard
//http://www.instructables.com/id/EJETQF0HAE69JCW/

/* Buttons to USB Keyboard Example

   You must select Keyboard from the "Tools > USB Type" menu

   This example code is in the public domain.
*/

#include <Bounce.h>

// Create Bounce objects for each button.  The Bounce object
// automatically deals with contact chatter or "bounce", and
// it makes detecting changes very simple.
Bounce L1 = Bounce(0, 10);
Bounce H1 = Bounce(1, 10);  // 10 = 10 ms debounce time
Bounce L2 = Bounce(2, 10);  // which is appropriate for
Bounce H2 = Bounce(3, 10);  // most mechanical pushbuttons
Bounce L3 = Bounce(4, 10);
Bounce H3 = Bounce(5, 10);  // if a button is too "sensitive"
Bounce L4 = Bounce(6, 10);  // to rapid touch, you can
Bounce H4 = Bounce(7, 10);  // increase this time.
Bounce L5 = Bounce(8, 10);
Bounce H5 = Bounce(9, 10);


void setup()
{
  // Configure the pins for input mode with pullup resistors.
  // The pushbuttons connect from each pin to ground.  When
  // the button is pressed, the pin reads LOW because the button
  // shorts it to ground.  When released, the pin reads HIGH
  // because the pullup resistor connects to +5 volts inside
  // the chip.  LOW for "on", and HIGH for "off" may seem
  // backwards, but using the on-chip pullup resistors is very
  // convenient.  The scheme is called "active low", and it's
  // very commonly used in electronics... so much that the chip
  // has built-in pullup resistors!
  pinMode(0, INPUT_PULLUP);
  pinMode(1, INPUT_PULLUP);
  pinMode(2, INPUT_PULLUP);
  pinMode(3, INPUT_PULLUP);
  pinMode(4, INPUT_PULLUP);
  pinMode(5, INPUT_PULLUP);
  pinMode(6, INPUT_PULLUP);  // Teensy++ LED, may need 1k resistor pullup
  pinMode(7, INPUT_PULLUP);
  pinMode(8, INPUT_PULLUP);
  pinMode(9, INPUT_PULLUP);
}

void loop() 
{
   // Update all the buttons.  There should not be any long
  // delays in loop(), so this runs repetitively at a rate
  // faster than the buttons could be pressed and released.
  L1.update();
  H1.update();
  L2.update();
  H2.update();
  L3.update();
  H3.update();
  L4.update();
  H4.update();
  L5.update();
  H5.update();

  // Check each button for "falling" edge.
  // Type a message on the Keyboard when each button presses
  // Update the Joystick buttons only upon changes.
  // falling = high (not pressed - voltage from pullup resistor)
  //           to low (pressed - button connects pin to ground)
  if (L1.fallingEdge()) {
    Keyboard.print("1");
  }
  if (H1.fallingEdge()) {
    Keyboard.print("6");
  }
  if (L2.fallingEdge()) {
    Keyboard.print("2");
  }
  if (H2.fallingEdge()) {
    Keyboard.print("7");
  }
  if (L3.fallingEdge()) {
    Keyboard.print("3");
  }
  if (H3.fallingEdge()) {
    Keyboard.print("8");
  }
  if (L4.fallingEdge()) {
    Keyboard.print("4");
  }
  if (H4.fallingEdge()) {
    Keyboard.print("9");
  }
  if (L5.fallingEdge()) {
    Keyboard.print("5");
  }
  if (H5.fallingEdge()) {
    Keyboard.print("-");
  }
  
}
