const byte defaultModesTop = 4;
const byte otherModesTop = 8;
const byte modeTypeTop = 1;

void readButtons() {
  powerButtonState = digitalRead(powerButtonPin);
  boostButtonState = digitalRead(boostButtonPin);
  if (powerButtonState == LOW || boostButtonState == LOW) {
    // Set the brightness levels to zero.
    OCR1B = 0;
    onTime = 0;
    sidesBrightness = 0;
    analogWrite(sidesPwmPin, 0);

    delayCounts = 0;
    if (powerButtonState == LOW) {
      while (powerButtonState == LOW) {
        delay(debounceDelay);
        delayCounts++;
        powerButtonState = digitalRead(powerButtonPin);
      }
      if (delayCounts <= 1) { // Increment mode.
        if (modeType == 0) {
          if (mode < defaultModesTop) {
            mode++;
          }
          else if (mode >= defaultModesTop) {
            mode = 0;
          }
        }
        else if (modeType == 1) {
          if (mode < otherModesTop) {
            mode++;
          }
          else if (mode >= otherModesTop) {
            mode = defaultModesTop + 1;
          }
        }
      }
      else if (delayCounts > 1 && delayCounts <= 5) { // Go to sleep.
        sleepNow();
      }
      else if (delayCounts > 5) { // Increment mode type.
        if (modeType < modeTypeTop) {
          modeType++;
          mode = defaultModesTop + 1;
        }
        else if (modeType >= modeTypeTop) {
          modeType = 0;
          mode = 0;
        }
      }
    }
    else if (boostButtonState == LOW) {
      while (boostButtonState == LOW) {
        delay(debounceDelay);
        delayCounts++;
        boostButtonState = digitalRead(boostButtonPin);
      }
      if (delayCounts <= 1) { // Enable or extend boost mode.
        prevMillis2 = millis();
        boostMode = true;
      }
      else if (delayCounts > 1) { // Cancel boost mode.
        boostMode = false;
      }
    }
  }
}
