#include <ESP8266WiFi.h>          //https://github.com/esp8266/Arduino

//needed for library
#include <DNSServer.h>
#include <ESP8266WebServer.h>
#include "libraries/WiFiManager.h"         //https://github.com/tzapu/WiFiManager

#include <ESP8266mDNS.h>
//#include <ArduinoOTA.h>
ESP8266WebServer server(80);

char* htmlHeader = "<html><head><meta name=\"viewport\" content=\"width=device-width\"><style type=\"text/css\">button {height:100px;width:100px;font-family:monospace;border-radius:5px;}</style></head><body><h1><a href=/>esp8266</a></h1>";
char* htmlFooter = "</body></html>";
//const char HTTP_STYLE[] PROGMEM  = "<style>.c{text-align: center;} div,input{padding:5px;font-size:1em;} input{width:95%;} body{text-align: center;font-family:verdana;} button{border:0;border-radius:0.3rem;background-color:#1fa3ec;color:#fff;line-height:2.4rem;font-size:1.2rem;width:100%;} .q{float: right;width: 64px;text-align: right;} .l{background: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAALVBMVEX///8EBwfBwsLw8PAzNjaCg4NTVVUjJiZDRUUUFxdiZGSho6OSk5Pg4eFydHTCjaf3AAAAZElEQVQ4je2NSw7AIAhEBamKn97/uMXEGBvozkWb9C2Zx4xzWykBhFAeYp9gkLyZE0zIMno9n4g19hmdY39scwqVkOXaxph0ZCXQcqxSpgQpONa59wkRDOL93eAXvimwlbPbwwVAegLS1HGfZAAAAABJRU5ErkJggg==\") no-repeat left center;background-size: 1em;}</style>";

const char* www_username = "admin";
const char* www_password = "esp8266";

#include <WiFiUdp.h>

#include <EEPROM.h>

#include "libraries/RF433.h"
//#define RFRX_PIN A4
#define RFTX_PIN 14 //D5
// MCE07
byte rf1off[] = {11,30,3,4,3,3,3,11,3,11,3,11,3,3,3,4,3,11,3,3,3,4,3,3,3,4,3,3,3,4,3,10,4,3,3,11,3,11,3,3,4,3,3,4,3,10,3,11,3,4,3,11,3,10,4,10,3,11,3,11,3,11,3,3,3,11,3,4,3,11,3,10,3,11,3,11,3,3,4,3,3,3,4,188,3,3,3,3,30,29,4,3,3,3,4,10,3,11,3,11,3,3,4,3,3,11,3,3,4,3,3,3,4,3,3,3,4,3,3,11,3,4,3,10,4};
byte rf1on[] = {5,3,3,3,29,30,3,4,3,3,3,11,3,11,3,10,4,3,3,3,4,10,4,3,3,3,4,3,3,3,4,3,3,4,3,10,3,4,3,11,3,11,3,3,3,4,3,3,3,11,3,11,3,4,3,10,3,11,3,11,3,11,3,11,3,10,3,4,3,11,3,11,3,3,3,4,3,3,3,4,3,10,4,10,3,11,3,90,3,3,4,3,29,30,3,3,3,4,3,11,3,10,4,10,3,4,3,3,3,11,3,4,3,3,3,4,3,3,3,4,3,3,3,11,3};
byte rf2off[] = {16,29,3,4,3,3,3,11,3,11,3,11,3,3,3,4,3,11,3,3,3,4,3,3,3,4,3,3,3,4,3,11,3,3,3,11,3,11,3,4,2,4,3,3,3,11,3,11,3,4,3,11,3,10,3,11,3,11,3,11,3,11,3,3,3,11,3,11,3,3,3,11,3,11,3,3,3,11,3,4,3,3,3,188,4,3,3,3,29,30,3,4,3,3,3,11,3,11,3,10,4,3,3,3,4,10,4,3,3,3,4,3,3,3,3,4,3,4,3,10,3,4,3,11,3};
byte rf2on[] = {4,11,3,3,3,11,3,4,3,3,3,11,3,3,3,11,3,11,3,188,3,3,4,2,30,30,3,3,3,4,3,10,3,11,3,11,3,4,3,3,3,11,3,4,3,3,3,4,3,3,3,4,3,3,3,11,3,4,3,11,3,10,3,4,3,3,3,4,3,11,3,10,3,4,3,11,3,11,3,11,3,10,3,11,3,11,3,4,3,11,3,3,3,11,3,3,3,4,3,11,3,3,3,11,3,11,3,90,3,3,3,3,30,30,3,3,3,4,3,10,3,11,3,11,3};
byte rf3off[] = {5,3,3,3,29,30,3,3,4,3,3,11,3,11,3,10,3,4,3,3,3,11,3,4,3,3,3,4,3,3,3,4,3,3,3,11,3,4,3,11,3,11,3,3,3,4,3,3,3,11,3,11,3,3,3,11,3,11,3,11,3,10,3,11,3,11,3,3,4,11,3,3,3,4,3,10,3,11,3,11,3,11,3,3,3,4,3,188,3,3,4,2,30,29,4,3,3,3,4,10,3,11,3,11,3,3,3,4,3,11,3,3,3,4,3,3,3,4,3,3,3,4,3,11,3};
byte rf3on[] = {5,2,4,3,29,30,3,3,3,4,3,11,3,10,3,11,3,4,3,3,3,11,3,4,3,3,3,4,3,3,3,4,3,3,3,11,3,4,3,11,3,11,3,3,3,4,3,3,3,11,3,11,3,3,3,11,3,11,3,11,3,11,3,10,3,11,3,4,3,11,3,11,3,10,3,4,3,3,3,4,3,3,3,11,3,11,3,90,3,3,4,3,29,30,3,3,3,4,3,11,3,10,4,10,3,4,3,3,3,11,3,4,3,3,3,4,3,3,3,4,3,3,3,11,3};
byte rf4off[] = {4,11,3,4,3,10,3,11,3,11,3,11,3,11,3,10,3,4,3,11,3,11,3,10,3,4,3,11,3,3,3,4,3,11,3,3,3,90,3,3,4,3,29,30,3,3,3,4,3,11,3,10,3,11,3,4,3,3,3,11,3,4,3,3,3,4,3,3,3,4,3,3,3,11,3,4,3,11,3,10,3,4,3,4,3,3,3,11,3,11,3,3,3,11,3,11,3,11,3,11,2,11,3,11,3,3,4,11,3,10,3,11,3,4,3,10,3,4,3,3,3,11,3,4,3};
byte rf4on[] = {4,4,3,10,4,89,4,3,3,3,29,30,3,4,3,3,3,11,3,11,3,10,3,4,3,3,3,11,3,4,3,3,3,4,3,3,3,4,3,3,3,11,3,4,3,11,3,11,3,3,3,4,3,3,3,11,3,11,3,3,3,11,3,11,3,11,3,11,2,11,3,11,3,3,4,11,3,3,3,4,3,10,3,4,3,11,3,10,3,4,3,11,3,188,3,3,3,3,30,29,3,4,3,3,3,11,3,11,3,10,4,3,3,3,4,11,3,3,3,4,3,3,3,4,3};

#include <WiFiUdp.h>
#include "libraries/NTPClient.h"
WiFiUDP ntpUDP;
NTPClient timeClient(ntpUDP);

#include "libraries/interval.h"
Interval minInterval, secInterval;

#include "libraries/Timezone.h"
//Central European Time (Frankfurt, Paris)
TimeChangeRule CEST = {"CEST", Last, Sun, Mar, 2, 120};     //Central European Summer Time
TimeChangeRule CET = {"CET ", Last, Sun, Oct, 3, 60};       //Central European Standard Time
Timezone CE(CEST, CET);

#define CONFIG_WIFIAP_PIN 4 //D2
#define CONFIG_WIFI_PIN 5	//D3

#define DEVICES_NUM 4

#define OUTPUT_BIT 0
#define MANUAL_BIT 1
#define CMD_BIT 2
#define RAIN_BIT 3

#define EEPROM_OFFSET 8

struct Device {
	byte onHour1;
	byte onMin1;
	unsigned int durationSec1;
	byte onHour2;
	byte onMin2;
	unsigned int durationSec2;
	byte flags;
	char name[8];
};

Device devices[DEVICES_NUM];

String getDeviceForm(int i, struct Device devices[]) {
	Device d = devices[i];
	String s = "<form action=/dev><input type=hidden name=id value=";
	s += i;
	s += "><h2>";
	s += i;
	s += ": ";
	s += d.name;
	s += "</h2><button type=submit name=cmd value=off>OFF</button>&nbsp;&nbsp;&nbsp;<button type=submit name=cmd value=on>ON</button>&nbsp;&nbsp;&nbsp;<button type=submit name=cmd value=auto>AUTO</button>";
	s += "<hr><h3>Settings:</h3>";
	s += "<hr>NAME<br><input name=n value=";
	s += d.name;
	s += "><hr>Switch ON at [hour] 1<br><input name=h1 value=";
	s += d.onHour1;
	s += "><hr>Switch ON at [min] 1<br><input name=m1 value=";
	s += d.onMin1;
	s += "><hr>Switch ON duration [min] 1<br><input name=d1 value=";
	s += d.durationSec1;
	s += "><hr>Switch ON at [hour] 2<br><input name=h2 value=";
	s += d.onHour2;
	s += "><hr>Switch ON at [min] 2<br><input name=m2 value=";
	s += d.onMin2;
	s += "><hr>Switch ON duration [min] 2<br><input name=d2 value=";
	s += d.durationSec2;
	s += "><hr>F<br><input name=f value=";
	s += d.flags;
	s += "><hr><button type=submit name=cmd value=set>SET</button>";

	s += "</form>";
	return s;
}

void handleRoot(){
   if(!server.authenticate(www_username, www_password))
      return server.requestAuthentication();

  Serial.println("Enter handleRoot");
  String message;
  server.send(200, "text/plain", message);
}

void setup() {
  // put your setup code here, to run once:


  Serial.begin(115200);
  Serial.print("\n\n");

  EEPROM.begin(512);
  if(!EEPROM.read(0)) {
	  for(int d=0; d< DEVICES_NUM; d++) {
		  EEPROM.get(EEPROM_OFFSET + sizeof(Device) * d, devices[d]);
	  }
  }

  pinMode(CONFIG_WIFIAP_PIN, INPUT_PULLUP);
  pinMode(CONFIG_WIFI_PIN, INPUT_PULLUP);
  pinMode(RFTX_PIN, OUTPUT);

  //WiFiManager
  //Local intialization. Once its business is done, there is no need to keep it around
  WiFiManager wifiManager;
  //reset saved settings
  //wifiManager.resetSettings();

  //set custom ip for portal
  //wifiManager.setAPConfig(IPAddress(10,0,1,1), IPAddress(10,0,1,1), IPAddress(255,255,255,0));

  //fetches ssid and pass from eeprom and tries to connect
  //if it does not connect it starts an access point with the specified name
  //here  "AutoConnectAP"
  //and goes into a blocking loop awaiting configuration
  if(digitalRead(CONFIG_WIFIAP_PIN) == LOW) {
	  WiFi.softAP("esp8266AP", "esp8266");
	  IPAddress myIP = WiFi.softAPIP();
	  Serial.println("Starting AP ...");
	  Serial.print("AP IP address: ");
	  Serial.println(myIP);

	  Serial.print("Open http://");
	  Serial.print(myIP);
	  Serial.println("/ in your browser to see it working");

	  //AP
  }
  else {
	  if ( digitalRead(CONFIG_WIFI_PIN) == LOW ) {
		  Serial.println("Starting AP for reconfiguration ...");
      	  wifiManager.startConfigPortal("esp8266");
      	  //AP
  	  }
  	  else {
  		  Serial.println("Starting AP or connecting to Wi-Fi ...");
  		  wifiManager.autoConnect("esp8266");
  	  }
  	  //or use this for auto generated name ESP + ChipID

  	  //if you get here you have connected to the WiFi
  	  Serial.println("Connected");
  	  Serial.print("Open http://");
  	  Serial.print(WiFi.localIP());
  	  Serial.println("/ in your browser to see it working");

  }

  server.on("/", [](){
    Serial.println("/");
    if(!server.authenticate(www_username, www_password))
      return server.requestAuthentication();

    String message = htmlHeader;

    //message += "Time: " + timeClient.getFormattedTime();
    time_t t = CE.toLocal(timeClient.getEpochTime());

    byte h = (t / 3600) % 24;
    byte m = (t / 60) % 60;
    byte s = t % 60;
    message += "Time: ";
    if(h<10)
    	message += '0';
    message += h;
    message += ":";
    if(m<10)
        	message += '0';
    message += m;
    message += ":";
    if(s<10)
        	message += '0';
    message += s;

    for(int i = 0; i < DEVICES_NUM; i++) {
    	message += "<hr><a href=./dev?id=";
    	message += i;
    	message += ">";
    	message += i;
    	message += ": ";
    	message += devices[i].name;
    	if(bitRead(devices[i].flags, MANUAL_BIT))
    		message += " MANUAL";
    	else
    		message += " AUTO";
    	if(bitRead(devices[i].flags, OUTPUT_BIT))
    	    		message += " ON";
    	    	else
    	    		message += " OFF";
    	message += "</a> ";
    }
    message += "</table>";
    message += "<hr><a href=./save>Save settings!</a>";
    message += htmlFooter;
    server.send(200, "text/html", message);
  });

  server.on("/save", [](){
      Serial.println("/save");
      if(!server.authenticate(www_username, www_password))
        return server.requestAuthentication();

      for(int d=0; d< DEVICES_NUM; d++) {
    	  EEPROM.put(EEPROM_OFFSET + sizeof(Device) * d, devices[d]);
      }
      EEPROM.write(0, 0);
      EEPROM.commit();

      char value;
      for(int i=0; i < 512; i++) {
    	  //EEPROM.write(addr, val);
    	  if(i % 32 == 0)
    		  Serial.println();
    	  value = EEPROM.read(i);
    	  Serial.print(value, HEX);
    	  Serial.print(' ');
      }

      String message = htmlHeader;
      message += "OK";
      message += htmlFooter;
      server.send(200, "text/html", message);

  });

  server.on("/dev", [](){
    Serial.println("/dev");
    if(!server.authenticate(www_username, www_password))
      return server.requestAuthentication();

    String cmd=server.arg("cmd");
    Serial.println(cmd);

	byte id=server.arg("id").toInt();
    if(cmd.equals("set")) {
    	byte onHour1=server.arg("h1").toInt();
    	byte onMin1=server.arg("m1").toInt();
    	unsigned int durationSec1=server.arg("d1").toInt();
    	byte onHour2=server.arg("h2").toInt();
    	byte onMin2=server.arg("m2").toInt();
    	unsigned int durationSec2=server.arg("d2").toInt();
    	String name=server.arg("n");

    	if(id >=0 && id < DEVICES_NUM) {
    		devices[id].onHour1 = onHour1;
    		devices[id].onMin1 = onMin1;
    		devices[id].durationSec1 = durationSec1;
    		devices[id].onHour2 = onHour2;
    		devices[id].onMin2 = onMin2;
    		devices[id].durationSec2 = durationSec2;
    		name.toCharArray(devices[id].name, 8);
    	}
    }
    if(cmd.equals("auto")) {
    	bitClear(devices[id].flags, MANUAL_BIT);
    }
    if(cmd.equals("off")) {
    	bitSet(devices[id].flags, MANUAL_BIT);
    	bitClear(devices[id].flags, CMD_BIT);
    	bitClear(devices[id].flags, OUTPUT_BIT);
    }
    if(cmd.equals("on")) {
    	bitSet(devices[id].flags, MANUAL_BIT);
    	bitSet(devices[id].flags, CMD_BIT);
    	bitSet(devices[id].flags, OUTPUT_BIT);
    }

  String message = htmlHeader;
	message += getDeviceForm(id, devices);
	message += htmlFooter;

    server.send(200, "text/html", message);
  });

  server.begin();
  timeClient.update();
}

void loop() {
  // put your main code here, to run repeatedly:

  // ArduinoOTA.handle();
  server.handleClient();

  if(minInterval.expired()) {
	  minInterval.set(60000);
	  timeClient.update();
  }
  if (secInterval.expired()) {
  		secInterval.set(1000);

  		//Serial.print('\n');
  		for(int i = 0; i < DEVICES_NUM; i++) {
  			unsigned int onSec1 = devices[i].onHour1 * 3600 + devices[i].onMin1 * 60;
  			unsigned int offSec1 = onSec1 + devices[i].durationSec1;
  			unsigned int onSec2 = devices[i].onHour2 * 3600 + devices[i].onMin2 * 60;
  			unsigned int offSec2 = onSec2 + devices[i].durationSec2;

  			//unsigned int onSec = timeClient.getHours() * 3600 + timeClient.getMinutes() * 60;
  			time_t t = CE.toLocal(timeClient.getEpochTime());
		    byte h = (t / 3600) % 24;
		    byte m = (t / 60) % 60;
		    byte s = t % 60;
		    unsigned int onSec = h * 3600 + m * 60;

  			unsigned int offSec = onSec;
  
  			bool out1 = false;
  			bool out2 = false;

  			if(offSec1 >= 24 * 60 * 60)
  				offSec = onSec + 24 * 60 * 60;
  			if(onSec >= onSec1 && offSec < offSec1) {
  				out1 = true;
  			}
  			if(offSec2 >= 24 * 60 * 60)
  				offSec = onSec + 24 * 60 * 60;
  			if(onSec >= onSec2 && offSec < offSec2) {
  				out2 = true;
  			}

  			if(!bitRead(devices[i].flags, MANUAL_BIT)) {
  				if(out1 || out2)
  					bitSet(devices[i].flags, OUTPUT_BIT);
  				else
  					bitClear(devices[i].flags, OUTPUT_BIT);
  			}
  			/*
  			Serial.print(devices[i].flags);
  			Serial.print('\t');
  			Serial.print(devices[i].name);
  			Serial.print('\n');*/
 		}

		if(bitRead(devices[0].flags, OUTPUT_BIT))
				sendSignal(RFTX_PIN, rf1on);
		else
			sendSignal(RFTX_PIN, rf1off);
    if(bitRead(devices[1].flags, OUTPUT_BIT))
        sendSignal(RFTX_PIN, rf2on);
    else
      sendSignal(RFTX_PIN, rf2off);
    if(bitRead(devices[2].flags, OUTPUT_BIT))
        sendSignal(RFTX_PIN, rf3on);
    else
      sendSignal(RFTX_PIN, rf3off);
    if(bitRead(devices[3].flags, OUTPUT_BIT))
        sendSignal(RFTX_PIN, rf4on);
    else
      sendSignal(RFTX_PIN, rf4off);
  }
}

